/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.content.IntentSender;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.internal.OpenFileIntentSenderRequest;
import com.google.android.gms.drive.internal.zzam;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.query.Filter;
import com.google.android.gms.drive.query.internal.FilterHolder;
import com.google.android.gms.drive.query.internal.zzg;

public class OpenFileActivityBuilder {
    public static final String EXTRA_RESPONSE_DRIVE_ID = "response_drive_id";
    private String zzavG;
    private String[] zzavH;
    private Filter zzavI;
    private DriveId zzavJ;

    public OpenFileActivityBuilder setActivityTitle(String string) {
        this.zzavG = (String)zzaa.zzz((Object)string);
        return this;
    }

    public OpenFileActivityBuilder setMimeType(String[] stringArray) {
        zzaa.zzb((stringArray != null ? 1 : 0) != 0, (Object)"mimeTypes may not be null");
        this.zzavH = stringArray;
        return this;
    }

    public OpenFileActivityBuilder setSelectionFilter(Filter filter) {
        zzaa.zzb((filter != null ? 1 : 0) != 0, (Object)"filter may not be null");
        zzaa.zzb((!zzg.zza(filter) ? 1 : 0) != 0, (Object)"FullTextSearchFilter cannot be used as a selection filter");
        this.zzavI = filter;
        return this;
    }

    public OpenFileActivityBuilder setActivityStartFolder(DriveId driveId) {
        this.zzavJ = (DriveId)((Object)zzaa.zzz((Object)((Object)driveId)));
        return this;
    }

    public IntentSender build(GoogleApiClient googleApiClient) {
        zzaa.zza((boolean)googleApiClient.isConnected(), (Object)"Client must be connected");
        if (this.zzavH == null) {
            this.zzavH = new String[0];
        }
        if (this.zzavH.length > 0 && this.zzavI != null) {
            throw new IllegalStateException("Cannot use a selection filter and set mimetypes simultaneously");
        }
        FilterHolder filterHolder = this.zzavI == null ? null : new FilterHolder(this.zzavI);
        try {
            zzam zzam2 = ((zzu)googleApiClient.zza(Drive.zzaaz)).zzwn();
            return zzam2.zza(new OpenFileIntentSenderRequest(this.zzavG, this.zzavH, this.zzavJ, filterHolder));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Unable to connect Drive Play Service", remoteException);
        }
    }
}

