/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ResourceEvent;
import com.google.android.gms.drive.events.zze;
import com.google.android.gms.drive.internal.zzap;
import com.google.android.gms.drive.internal.zzz;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzqd;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class CompletionEvent
extends AbstractSafeParcelable
implements ResourceEvent {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_CONFLICT = 2;
    public static final int STATUS_CANCELED = 3;
    public static final Parcelable.Creator<CompletionEvent> CREATOR = new zze();
    final int mVersionCode;
    final DriveId zzauZ;
    final String zzaaR;
    final ParcelFileDescriptor zzawd;
    final ParcelFileDescriptor zzawe;
    final MetadataBundle zzawf;
    final List<String> zzawg;
    final int zzDO;
    final IBinder zzawh;
    private boolean zzawi = false;
    private boolean zzawj = false;
    private boolean zzawk = false;

    CompletionEvent(int n, DriveId driveId, String string, ParcelFileDescriptor parcelFileDescriptor, ParcelFileDescriptor parcelFileDescriptor2, MetadataBundle metadataBundle, List<String> list, int n2, IBinder iBinder) {
        this.mVersionCode = n;
        this.zzauZ = driveId;
        this.zzaaR = string;
        this.zzawd = parcelFileDescriptor;
        this.zzawe = parcelFileDescriptor2;
        this.zzawf = metadataBundle;
        this.zzawg = list;
        this.zzDO = n2;
        this.zzawh = iBinder;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n | 1);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public DriveId getDriveId() {
        this.zzwd();
        return this.zzauZ;
    }

    public String getAccountName() {
        this.zzwd();
        return this.zzaaR;
    }

    public InputStream getBaseContentsInputStream() {
        this.zzwd();
        if (this.zzawd == null) {
            return null;
        }
        if (this.zzawi) {
            throw new IllegalStateException("getBaseInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzawi = true;
        return new FileInputStream(this.zzawd.getFileDescriptor());
    }

    public InputStream getModifiedContentsInputStream() {
        this.zzwd();
        if (this.zzawe == null) {
            return null;
        }
        if (this.zzawj) {
            throw new IllegalStateException("getModifiedInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzawj = true;
        return new FileInputStream(this.zzawe.getFileDescriptor());
    }

    public MetadataChangeSet getModifiedMetadataChangeSet() {
        this.zzwd();
        return this.zzawf != null ? new MetadataChangeSet(this.zzawf) : null;
    }

    public List<String> getTrackingTags() {
        this.zzwd();
        return new ArrayList<String>(this.zzawg);
    }

    public int getStatus() {
        this.zzwd();
        return this.zzDO;
    }

    public void dismiss() {
        this.zzx(false);
    }

    public void snooze() {
        this.zzx(true);
    }

    private void zzx(boolean bl) {
        this.zzwd();
        this.zzawk = true;
        zzo.zza((ParcelFileDescriptor)this.zzawd);
        zzo.zza((ParcelFileDescriptor)this.zzawe);
        if (this.zzawf != null && this.zzawf.zzc(zzqd.zzaAa)) {
            this.zzawf.zza(zzqd.zzaAa).release();
        }
        if (this.zzawh == null) {
            String string = String.valueOf(bl ? "snooze" : "dismiss");
            zzz.zzE("CompletionEvent", string.length() != 0 ? "No callback on ".concat(string) : new String("No callback on "));
            return;
        }
        try {
            zzap.zza.zzbk(this.zzawh).zzx(bl);
        }
        catch (RemoteException remoteException) {
            String string = bl ? "snooze" : "dismiss";
            String string2 = String.valueOf((Object)remoteException);
            zzz.zzE("CompletionEvent", new StringBuilder(21 + String.valueOf(string).length() + String.valueOf(string2).length()).append("RemoteException on ").append(string).append(": ").append(string2).toString());
        }
    }

    private void zzwd() {
        if (this.zzawk) {
            throw new IllegalStateException("Event has already been dismissed or snoozed.");
        }
    }

    public String toString() {
        String string;
        if (this.zzawg == null) {
            string = "<null>";
        } else {
            String string2 = String.valueOf(TextUtils.join((CharSequence)"','", this.zzawg));
            string = new StringBuilder(2 + String.valueOf(string2).length()).append("'").append(string2).append("'").toString();
        }
        String string3 = string;
        return String.format(Locale.US, "CompletionEvent [id=%s, status=%s, trackingTag=%s]", new Object[]{this.zzauZ, this.zzDO, string3});
    }
}

