/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.Metadata;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.internal.DeleteResourceRequest;
import com.google.android.gms.drive.internal.GetMetadataRequest;
import com.google.android.gms.drive.internal.ListParentsRequest;
import com.google.android.gms.drive.internal.OnListParentsResponse;
import com.google.android.gms.drive.internal.OnMetadataResponse;
import com.google.android.gms.drive.internal.SetResourceParentsRequest;
import com.google.android.gms.drive.internal.TrashResourceRequest;
import com.google.android.gms.drive.internal.UntrashResourceRequest;
import com.google.android.gms.drive.internal.UpdateMetadataRequest;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzbr;
import com.google.android.gms.drive.internal.zzp;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.internal.zznt;
import java.util.ArrayList;
import java.util.Set;

public class zzab
implements DriveResource {
    protected final DriveId zzauZ;

    public zzab(DriveId driveId) {
        this.zzauZ = driveId;
    }

    @Override
    public DriveId getDriveId() {
        return this.zzauZ;
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> getMetadata(GoogleApiClient googleApiClient) {
        return this.zza(googleApiClient, false);
    }

    private PendingResult<DriveResource.MetadataResult> zza(GoogleApiClient googleApiClient, final boolean bl) {
        return googleApiClient.zzc((zznt.zza)new zzd(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzwn().zza(new GetMetadataRequest(zzab.this.zzauZ, bl), (zzan)new zzb((zznt.zzb<DriveResource.MetadataResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listParents(GoogleApiClient googleApiClient) {
        return googleApiClient.zzc((zznt.zza)new zzs.zzh(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzwn().zza(new ListParentsRequest(zzab.this.zzauZ), (zzan)new zza((zznt.zzb<DriveApi.MetadataBufferResult>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> setParents(GoogleApiClient googleApiClient, Set<DriveId> set) {
        if (set == null) {
            throw new IllegalArgumentException("ParentIds must be provided.");
        }
        final ArrayList<DriveId> arrayList = new ArrayList<DriveId>(set);
        return googleApiClient.zzd((zznt.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzwn().zza(new SetResourceParentsRequest(zzab.this.zzauZ, arrayList), (zzan)new zzbr((zznt.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> updateMetadata(GoogleApiClient googleApiClient, final MetadataChangeSet metadataChangeSet) {
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("ChangeSet must be provided.");
        }
        return googleApiClient.zzd((zznt.zza)new zzd(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                metadataChangeSet.zzvU().setContext(zzu2.getContext());
                zzu2.zzwn().zza(new UpdateMetadataRequest(zzab.this.zzauZ, metadataChangeSet.zzvU()), (zzan)new zzb((zznt.zzb<DriveResource.MetadataResult>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> delete(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zznt.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzwn().zza(new DeleteResourceRequest(zzab.this.zzauZ), (zzan)new zzbr((zznt.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> addChangeListener(GoogleApiClient googleApiClient, ChangeListener changeListener) {
        zzu zzu2 = (zzu)googleApiClient.zza(Drive.zzaaz);
        return zzu2.zza(googleApiClient, this.zzauZ, changeListener);
    }

    @Override
    public PendingResult<Status> removeChangeListener(GoogleApiClient googleApiClient, ChangeListener changeListener) {
        zzu zzu2 = (zzu)googleApiClient.zza(Drive.zzaaz);
        return zzu2.zzb(googleApiClient, this.zzauZ, changeListener);
    }

    @Override
    public PendingResult<Status> addChangeSubscription(GoogleApiClient googleApiClient) {
        zzu zzu2 = (zzu)googleApiClient.zza(Drive.zzaaz);
        return zzu2.zza(googleApiClient, this.zzauZ);
    }

    @Override
    public PendingResult<Status> removeChangeSubscription(GoogleApiClient googleApiClient) {
        zzu zzu2 = (zzu)googleApiClient.zza(Drive.zzaaz);
        return zzu2.zzb(googleApiClient, this.zzauZ);
    }

    @Override
    public PendingResult<Status> trash(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zznt.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzwn().zza(new TrashResourceRequest(zzab.this.zzauZ), (zzan)new zzbr((zznt.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> untrash(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zznt.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzwn().zza(new UntrashResourceRequest(zzab.this.zzauZ), (zzan)new zzbr((zznt.zzb<Status>)this));
            }
        });
    }

    private static class zza
    extends com.google.android.gms.drive.internal.zzd {
        private final zznt.zzb<DriveApi.MetadataBufferResult> zzasz;

        public zza(zznt.zzb<DriveApi.MetadataBufferResult> zzb2) {
            this.zzasz = zzb2;
        }

        @Override
        public void zza(OnListParentsResponse onListParentsResponse) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(onListParentsResponse.zzwB());
            this.zzasz.setResult((Object)new zzs.zzg(Status.zzalw, metadataBuffer, false));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzasz.setResult((Object)new zzs.zzg(status, null, false));
        }
    }

    private static class zzb
    extends com.google.android.gms.drive.internal.zzd {
        private final zznt.zzb<DriveResource.MetadataResult> zzasz;

        public zzb(zznt.zzb<DriveResource.MetadataResult> zzb2) {
            this.zzasz = zzb2;
        }

        @Override
        public void zza(OnMetadataResponse onMetadataResponse) throws RemoteException {
            this.zzasz.setResult((Object)new zzc(Status.zzalw, new zzp(onMetadataResponse.zzwC())));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzasz.setResult((Object)new zzc(status, null));
        }
    }

    private static class zzc
    implements DriveResource.MetadataResult {
        private final Status zzaaO;
        private final Metadata zzayb;

        public zzc(Status status, Metadata metadata) {
            this.zzaaO = status;
            this.zzayb = metadata;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public Metadata getMetadata() {
            return this.zzayb;
        }
    }

    private abstract class zzd
    extends zzt<DriveResource.MetadataResult> {
        private zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveResource.MetadataResult zzL(Status status) {
            return new zzc(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzL(status);
        }
    }
}

