/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.util.zzb;
import com.google.android.gms.fido.common.Transport;
import com.google.android.gms.fido.u2f.api.common.ProtocolVersion;
import com.google.android.gms.fido.u2f.api.common.zzg;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KeyHandle
extends zzbck {
    public static final Parcelable.Creator<KeyHandle> CREATOR = new zzg();
    private final int zzdxr;
    private final byte[] zzgqt;
    private final ProtocolVersion zzgqu;
    private final List<Transport> zzdks;

    KeyHandle(int n, byte[] byArray, String string, List<Transport> list) {
        this.zzdxr = n;
        this.zzgqt = byArray;
        try {
            this.zzgqu = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new IllegalArgumentException(unsupportedProtocolException);
        }
        this.zzdks = list;
    }

    public KeyHandle(byte[] byArray, ProtocolVersion protocolVersion, List<Transport> list) {
        this.zzdxr = 1;
        this.zzgqt = byArray;
        this.zzgqu = protocolVersion;
        this.zzdks = list;
    }

    public static KeyHandle parseFromJson(JSONObject jSONObject) throws JSONException {
        byte[] byArray;
        ProtocolVersion protocolVersion;
        String string = null;
        if (jSONObject.has("version")) {
            string = jSONObject.getString("version");
        }
        try {
            protocolVersion = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new JSONException(unsupportedProtocolException.toString());
        }
        String string2 = jSONObject.getString("keyHandle");
        try {
            byArray = Base64.decode((String)string2, (int)8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JSONException(illegalArgumentException.toString());
        }
        JSONObject jSONObject2 = jSONObject;
        List<Transport> list = !jSONObject2.has("transports") ? null : Transport.parseTransports(jSONObject2.getJSONArray("transports"));
        return new KeyHandle(byArray, protocolVersion, list);
    }

    public int getVersionCode() {
        return this.zzdxr;
    }

    public byte[] getBytes() {
        return this.zzgqt;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.zzgqu;
    }

    public List<Transport> getTransports() {
        return this.zzdks;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        KeyHandle keyHandle = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)1, (int)keyHandle.getVersionCode());
        zzbcn.zza((Parcel)parcel2, (int)2, (byte[])keyHandle.getBytes(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (String)keyHandle.zzgqu.toString(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)4, keyHandle.getTransports(), (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        String string = this.zzdks == null ? "null" : this.zzdks.toString();
        return String.format("{keyHandle: %s, version: %s, transports: %s}", new Object[]{zzb.encode((byte[])this.zzgqt), this.zzgqu, string});
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{Arrays.hashCode(this.zzgqt), this.zzgqu, this.zzdks});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        KeyHandle keyHandle = (KeyHandle)((Object)object);
        if (!Arrays.equals(this.zzgqt, keyHandle.zzgqt)) {
            return false;
        }
        if (!this.zzgqu.equals((Object)keyHandle.zzgqu)) {
            return false;
        }
        if (this.zzdks == null && keyHandle.zzdks == null) {
            return true;
        }
        if (this.zzdks == null || keyHandle.zzdks == null) {
            return false;
        }
        return this.zzdks.containsAll(keyHandle.zzdks) && keyHandle.zzdks.containsAll(this.zzdks);
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.zzgqt != null) {
                jSONObject.put("keyHandle", (Object)Base64.encodeToString((byte[])this.zzgqt, (int)11));
            }
            if (this.zzgqu != null) {
                jSONObject.put("version", (Object)this.zzgqu.toString());
            }
            if (this.zzdks != null) {
                JSONArray jSONArray = new JSONArray();
                for (Transport transport : this.zzdks) {
                    jSONArray.put((Object)transport.toString());
                }
                jSONObject.put("transports", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        return jSONObject;
    }
}

