/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fido.u2f.api.common.ChannelIdValue;
import com.google.android.gms.fido.u2f.api.common.RegisterRequest;
import com.google.android.gms.fido.u2f.api.common.RegisteredKey;
import com.google.android.gms.fido.u2f.api.common.RequestParams;
import com.google.android.gms.fido.u2f.api.common.zzj;
import com.google.android.gms.internal.zzbcn;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RegisterRequestParams
extends RequestParams {
    public static final Parcelable.Creator<RegisterRequestParams> CREATOR = new zzj();
    public static final int MAX_DISPLAY_HINT_LENGTH = 80;
    private final Integer zzggn;
    private final Double zzgqx;
    private final Uri zzgqy;
    private final List<RegisterRequest> zzgqz;
    private final List<RegisteredKey> zzgra;
    private final ChannelIdValue zzgrb;
    private final String zzgrc;
    private Set<Uri> zzgrd;

    RegisterRequestParams(Integer n, Double d, Uri uri, List<RegisterRequest> list, List<RegisteredKey> list2, ChannelIdValue channelIdValue, String string) {
        this.zzggn = n;
        this.zzgqx = d;
        this.zzgqy = uri;
        zzbp.zzb((list != null && !list.isEmpty() ? 1 : 0) != 0, (Object)"empty list of register requests is provided");
        this.zzgqz = list;
        this.zzgra = list2;
        this.zzgrb = channelIdValue;
        List<RegisteredKey> list3 = this.zzgra;
        List<RegisterRequest> list4 = this.zzgqz;
        Uri uri2 = this.zzgqy;
        HashSet<Uri> hashSet = new HashSet<Uri>();
        if (uri2 != null) {
            hashSet.add(uri2);
        }
        for (RegisterRequest zzbck2 : list4) {
            zzbp.zzb((uri2 != null || zzbck2.getAppId() != null ? 1 : 0) != 0, (Object)"register request has null appId and no request appId is provided");
            if (zzbck2.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)zzbck2.getAppId()));
        }
        for (RegisteredKey registeredKey : list3) {
            zzbp.zzb((uri2 != null || registeredKey.getAppId() != null ? 1 : 0) != 0, (Object)"registered key has null appId and no request appId is provided");
            if (registeredKey.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)registeredKey.getAppId()));
        }
        this.zzgrd = hashSet;
        zzbp.zzb((string == null || string.length() <= 80 ? 1 : 0) != 0, (Object)"Display Hint cannot be longer than 80 characters");
        this.zzgrc = string;
    }

    @Override
    public Integer getRequestId() {
        return this.zzggn;
    }

    @Override
    public Double getTimeoutSeconds() {
        return this.zzgqx;
    }

    @Override
    public Uri getAppId() {
        return this.zzgqy;
    }

    @Override
    public Set<Uri> getAllAppIds() {
        return this.zzgrd;
    }

    public List<RegisterRequest> getRegisterRequests() {
        return this.zzgqz;
    }

    @Override
    public List<RegisteredKey> getRegisteredKeys() {
        return this.zzgra;
    }

    @Override
    public ChannelIdValue getChannelIdValue() {
        return this.zzgrb;
    }

    @Override
    public String getDisplayHint() {
        return this.zzgrc;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        RegisterRequestParams registerRequestParams = (RegisterRequestParams)((Object)object);
        return zzbf.equal((Object)this.zzggn, (Object)registerRequestParams.zzggn) && zzbf.equal((Object)this.zzgqx, (Object)registerRequestParams.zzgqx) && zzbf.equal((Object)this.zzgqy, (Object)registerRequestParams.zzgqy) && zzbf.equal(this.zzgqz, registerRequestParams.zzgqz) && (this.zzgra == null && registerRequestParams.zzgra == null || this.zzgra != null && registerRequestParams.zzgra != null && this.zzgra.containsAll(registerRequestParams.zzgra) && registerRequestParams.zzgra.containsAll(this.zzgra)) && zzbf.equal((Object)((Object)this.zzgrb), (Object)((Object)registerRequestParams.zzgrb)) && zzbf.equal((Object)this.zzgrc, (Object)registerRequestParams.zzgrc);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzggn, this.zzgqy, this.zzgqx, this.zzgqz, this.zzgra, this.zzgrb, this.zzgrc});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RegisterRequestParams registerRequestParams = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)2, (Integer)((RequestParams)registerRequestParams).getRequestId(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (Double)((RequestParams)registerRequestParams).getTimeoutSeconds(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (Parcelable)((RequestParams)registerRequestParams).getAppId(), (int)n, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)5, registerRequestParams.getRegisterRequests(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)6, ((RequestParams)registerRequestParams).getRegisteredKeys(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)7, (Parcelable)((RequestParams)registerRequestParams).getChannelIdValue(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)8, (String)((RequestParams)registerRequestParams).getDisplayHint(), (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private Integer zzggn;
        private Double zzgqx;
        private Uri zzgqy;
        private List<RegisterRequest> zzgqz;
        private List<RegisteredKey> zzgra;
        private ChannelIdValue zzgrb;
        private String zzgrc;

        public Builder() {
        }

        public final Builder setRequestId(Integer n) {
            this.zzggn = n;
            return this;
        }

        public final Builder setTimeoutSeconds(Double d) {
            this.zzgqx = d;
            return this;
        }

        public final Builder setAppId(Uri uri) {
            this.zzgqy = uri;
            return this;
        }

        public final Builder setRegisterRequests(List<RegisterRequest> list) {
            this.zzgqz = list;
            return this;
        }

        public final Builder setRegisteredKeys(List<RegisteredKey> list) {
            this.zzgra = list;
            return this;
        }

        public final Builder setChannelIdValue(ChannelIdValue channelIdValue) {
            this.zzgrb = channelIdValue;
            return this;
        }

        public final Builder setDisplayHint(String string) {
            this.zzgrc = string;
            return this;
        }

        public final RegisterRequestParams build() {
            return new RegisterRequestParams(this.zzggn, this.zzgqx, this.zzgqy, this.zzgqz, this.zzgra, this.zzgrb, this.zzgrc);
        }
    }
}

