/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fido.u2f.api.common.ErrorCode;
import com.google.android.gms.fido.u2f.api.common.ResponseData;
import com.google.android.gms.fido.u2f.api.common.zzf;
import com.google.android.gms.internal.zzbcn;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class ErrorResponseData
extends ResponseData {
    public static final Parcelable.Creator<ErrorResponseData> CREATOR = new zzf();
    public static final String JSON_ERROR_CODE = "errorCode";
    public static final String JSON_ERROR_MESSAGE = "errorMessage";
    private final ErrorCode zzgqr;
    private final String mErrorMessage;

    ErrorResponseData(int n, String string) {
        this.zzgqr = ErrorCode.toErrorCode(n);
        this.mErrorMessage = string;
    }

    public ErrorResponseData(ErrorCode errorCode) {
        this.zzgqr = (ErrorCode)((Object)zzbp.zzu((Object)((Object)errorCode)));
        this.mErrorMessage = null;
    }

    public ErrorResponseData(ErrorCode errorCode, String string) {
        this.zzgqr = (ErrorCode)((Object)zzbp.zzu((Object)((Object)errorCode)));
        this.mErrorMessage = string;
    }

    public ErrorCode getErrorCode() {
        return this.zzgqr;
    }

    public int getErrorCodeAsInt() {
        return this.zzgqr.getCode();
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public String toString() {
        if (this.mErrorMessage == null) {
            return String.format(Locale.ENGLISH, "{errorCode: %d}", this.zzgqr.getCode());
        }
        return String.format(Locale.ENGLISH, "{errorCode: %d, errorMessage: %s}", this.zzgqr.getCode(), this.mErrorMessage);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        ErrorResponseData errorResponseData = (ErrorResponseData)((Object)object);
        return zzbf.equal((Object)((Object)this.zzgqr), (Object)((Object)errorResponseData.zzgqr)) && zzbf.equal((Object)this.mErrorMessage, (Object)errorResponseData.mErrorMessage);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgqr, this.mErrorMessage});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ErrorResponseData errorResponseData = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)2, (int)errorResponseData.getErrorCodeAsInt());
        zzbcn.zza((Parcel)parcel2, (int)3, (String)errorResponseData.getErrorMessage(), (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    @Override
    public JSONObject toJsonObject() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(JSON_ERROR_CODE, this.zzgqr.getCode());
            if (this.mErrorMessage != null) {
                jSONObject.put(JSON_ERROR_MESSAGE, (Object)this.mErrorMessage);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }
}

