/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fido.u2f.api.common.ChannelIdValue;
import com.google.android.gms.fido.u2f.api.common.RegisteredKey;
import com.google.android.gms.fido.u2f.api.common.RequestParams;
import com.google.android.gms.fido.u2f.api.common.zzm;
import com.google.android.gms.internal.zzbcn;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SignRequestParams
extends RequestParams {
    public static final Parcelable.Creator<SignRequestParams> CREATOR = new zzm();
    public static final int MAX_DISPLAY_HINT_LENGTH = 80;
    private final Integer zzggo;
    private final Double zzgqy;
    private final Uri zzgqz;
    private final byte[] zzgrj;
    private final List<RegisteredKey> zzgrb;
    private final ChannelIdValue zzgrc;
    private final String zzgrd;
    private final Set<Uri> zzgre;

    SignRequestParams(Integer n, Double d, Uri uri, byte[] byArray, List<RegisteredKey> list, ChannelIdValue channelIdValue, String string) {
        this.zzggo = n;
        this.zzgqy = d;
        this.zzgqz = uri;
        this.zzgrj = byArray;
        zzbp.zzb((list != null && !list.isEmpty() ? 1 : 0) != 0, (Object)"registeredKeys must not be null or empty");
        this.zzgrb = list;
        this.zzgrc = channelIdValue;
        List<RegisteredKey> list2 = list;
        Uri uri2 = uri;
        HashSet<Uri> hashSet = new HashSet<Uri>();
        if (uri2 != null) {
            hashSet.add(uri2);
        }
        for (RegisteredKey registeredKey : list2) {
            zzbp.zzb((registeredKey.getAppId() != null || uri2 != null ? 1 : 0) != 0, (Object)"registered key has null appId and no request appId is provided");
            zzbp.zzb((registeredKey.getChallengeValue() != null || list2 != null ? 1 : 0) != 0, (Object)"register request has null challenge and no default challenge isprovided");
            if (registeredKey.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)registeredKey.getAppId()));
        }
        this.zzgre = hashSet;
        zzbp.zzb((string == null || string.length() <= 80 ? 1 : 0) != 0, (Object)"Display Hint cannot be longer than 80 characters");
        this.zzgrd = string;
    }

    @Override
    public Integer getRequestId() {
        return this.zzggo;
    }

    @Override
    public Double getTimeoutSeconds() {
        return this.zzgqy;
    }

    @Override
    public Uri getAppId() {
        return this.zzgqz;
    }

    @Override
    public Set<Uri> getAllAppIds() {
        return this.zzgre;
    }

    public byte[] getDefaultSignChallenge() {
        return this.zzgrj;
    }

    @Override
    public List<RegisteredKey> getRegisteredKeys() {
        return this.zzgrb;
    }

    @Override
    public ChannelIdValue getChannelIdValue() {
        return this.zzgrc;
    }

    @Override
    public String getDisplayHint() {
        return this.zzgrd;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        SignRequestParams signRequestParams = (SignRequestParams)((Object)object);
        return zzbf.equal((Object)this.zzggo, (Object)signRequestParams.zzggo) && zzbf.equal((Object)this.zzgqy, (Object)signRequestParams.zzgqy) && zzbf.equal((Object)this.zzgqz, (Object)signRequestParams.zzgqz) && Arrays.equals(this.zzgrj, signRequestParams.zzgrj) && this.zzgrb.containsAll(signRequestParams.zzgrb) && signRequestParams.zzgrb.containsAll(this.zzgrb) && zzbf.equal((Object)((Object)this.zzgrc), (Object)((Object)signRequestParams.zzgrc)) && zzbf.equal((Object)this.zzgrd, (Object)signRequestParams.zzgrd);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzggo, this.zzgqz, this.zzgqy, this.zzgrb, this.zzgrc, this.zzgrd, Arrays.hashCode(this.zzgrj)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SignRequestParams signRequestParams = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)2, (Integer)((RequestParams)signRequestParams).getRequestId(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (Double)((RequestParams)signRequestParams).getTimeoutSeconds(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (Parcelable)((RequestParams)signRequestParams).getAppId(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)5, (byte[])signRequestParams.getDefaultSignChallenge(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)6, ((RequestParams)signRequestParams).getRegisteredKeys(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)7, (Parcelable)((RequestParams)signRequestParams).getChannelIdValue(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)8, (String)((RequestParams)signRequestParams).getDisplayHint(), (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private Integer zzggo;
        private Double zzgqy;
        private Uri zzgqz;
        private byte[] zzgrj;
        private List<RegisteredKey> zzgrb;
        private ChannelIdValue zzgrc;
        private String zzgrd;

        public Builder() {
        }

        public final Builder setRequestId(Integer n) {
            this.zzggo = n;
            return this;
        }

        public final Builder setTimeoutSeconds(Double d) {
            this.zzgqy = d;
            return this;
        }

        public final Builder setAppId(Uri uri) {
            this.zzgqz = uri;
            return this;
        }

        public final Builder setDefaultSignChallenge(byte[] byArray) {
            this.zzgrj = byArray;
            return this;
        }

        public final Builder setRegisteredKeys(List<RegisteredKey> list) {
            this.zzgrb = list;
            return this;
        }

        public final Builder setChannelIdValue(ChannelIdValue channelIdValue) {
            this.zzgrc = channelIdValue;
            return this;
        }

        public final Builder setDisplayHint(String string) {
            this.zzgrd = string;
            return this;
        }

        public final SignRequestParams build() {
            return new SignRequestParams(this.zzggo, this.zzgqy, this.zzgqz, this.zzgrj, this.zzgrb, this.zzgrc, this.zzgrd);
        }
    }
}

