/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.u2f.api.common.zzb;
import com.google.android.gms.fido.u2f.api.common.zzc;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import org.json.JSONException;
import org.json.JSONObject;

public class ChannelIdValue
extends zzbej {
    public static final Parcelable.Creator<ChannelIdValue> CREATOR = new zzc();
    public static final ChannelIdValue ABSENT = new ChannelIdValue();
    public static final ChannelIdValue UNAVAILABLE = new ChannelIdValue("unavailable");
    public static final ChannelIdValue UNUSED = new ChannelIdValue("unused");
    private final ChannelIdValueType zzgvi;
    private final String zzgvj;
    private final String zzgvk;

    ChannelIdValue(int n, String string, String string2) {
        try {
            this.zzgvi = ChannelIdValue.toChannelIdValueType(n);
        }
        catch (UnsupportedChannelIdValueTypeException unsupportedChannelIdValueTypeException) {
            throw new IllegalArgumentException(unsupportedChannelIdValueTypeException);
        }
        this.zzgvj = string;
        this.zzgvk = string2;
    }

    public ChannelIdValue(JSONObject jSONObject) {
        this.zzgvk = (String)zzbq.checkNotNull((Object)jSONObject.toString());
        this.zzgvi = ChannelIdValueType.OBJECT;
        this.zzgvj = null;
    }

    private ChannelIdValue() {
        this.zzgvi = ChannelIdValueType.ABSENT;
        this.zzgvk = null;
        this.zzgvj = null;
    }

    private ChannelIdValue(String string) {
        this.zzgvj = (String)zzbq.checkNotNull((Object)string);
        this.zzgvi = ChannelIdValueType.STRING;
        this.zzgvk = null;
    }

    public static ChannelIdValueType toChannelIdValueType(int n) throws UnsupportedChannelIdValueTypeException {
        for (ChannelIdValueType channelIdValueType : ChannelIdValueType.values()) {
            if (n != channelIdValueType.zzefo) continue;
            return channelIdValueType;
        }
        throw new UnsupportedChannelIdValueTypeException(n);
    }

    public int getTypeAsInt() {
        return this.zzgvi.zzefo;
    }

    public ChannelIdValueType getType() {
        return this.zzgvi;
    }

    public String getObjectValueAsString() {
        return this.zzgvk;
    }

    public JSONObject getObjectValue() {
        if (this.zzgvk == null) {
            return null;
        }
        try {
            return new JSONObject(this.zzgvk);
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public String getStringValue() {
        return this.zzgvj;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ChannelIdValue channelIdValue = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zzc((Parcel)parcel2, (int)2, (int)channelIdValue.getTypeAsInt());
        zzbem.zza((Parcel)parcel2, (int)3, (String)channelIdValue.getStringValue(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (String)channelIdValue.getObjectValueAsString(), (boolean)false);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ChannelIdValue)) {
            return false;
        }
        ChannelIdValue channelIdValue = (ChannelIdValue)((Object)object);
        if (!this.zzgvi.equals((Object)channelIdValue.zzgvi)) {
            return false;
        }
        switch (this.zzgvi) {
            case ABSENT: {
                return true;
            }
            case STRING: {
                return this.zzgvj.equals(channelIdValue.zzgvj);
            }
            case OBJECT: {
                return this.zzgvk.equals(channelIdValue.zzgvk);
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 31 + this.zzgvi.hashCode();
        switch (this.zzgvi) {
            case ABSENT: {
                break;
            }
            case STRING: {
                n = n * 31 + this.zzgvj.hashCode();
                break;
            }
            case OBJECT: {
                n = n * 31 + this.zzgvk.hashCode();
            }
        }
        return n;
    }

    public static class UnsupportedChannelIdValueTypeException
    extends Exception {
        public UnsupportedChannelIdValueTypeException(int n) {
            super(String.format("ChannelIdValueType %s not supported", n));
        }
    }

    public static enum ChannelIdValueType implements Parcelable
    {
        ABSENT(0),
        STRING(1),
        OBJECT(2);

        public static final Parcelable.Creator<ChannelIdValueType> CREATOR;
        private final int zzefo;

        private ChannelIdValueType(int n2) {
            this.zzefo = n2;
        }

        public final int describeContents() {
            return 0;
        }

        public final void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.zzefo);
        }

        static {
            CREATOR = new zzb();
        }
    }
}

