/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.u2f.api.common.ChannelIdValue;
import com.google.android.gms.fido.u2f.api.common.RegisterRequest;
import com.google.android.gms.fido.u2f.api.common.RegisteredKey;
import com.google.android.gms.fido.u2f.api.common.RequestParams;
import com.google.android.gms.fido.u2f.api.common.zzj;
import com.google.android.gms.internal.zzbem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RegisterRequestParams
extends RequestParams {
    public static final Parcelable.Creator<RegisterRequestParams> CREATOR = new zzj();
    public static final int MAX_DISPLAY_HINT_LENGTH = 80;
    private final Integer zzgkh;
    private final Double zzgvw;
    private final Uri zzgvx;
    private final List<RegisterRequest> zzgvy;
    private final List<RegisteredKey> zzgvz;
    private final ChannelIdValue zzgwa;
    private final String zzgwb;
    private Set<Uri> zzgwc;

    RegisterRequestParams(Integer n, Double d, Uri uri, List<RegisterRequest> list, List<RegisteredKey> list2, ChannelIdValue channelIdValue, String string) {
        this.zzgkh = n;
        this.zzgvw = d;
        this.zzgvx = uri;
        zzbq.checkArgument((list != null && !list.isEmpty() ? 1 : 0) != 0, (Object)"empty list of register requests is provided");
        this.zzgvy = list;
        this.zzgvz = list2;
        this.zzgwa = channelIdValue;
        List<RegisteredKey> list3 = this.zzgvz;
        List<RegisterRequest> list4 = this.zzgvy;
        Uri uri2 = this.zzgvx;
        HashSet<Uri> hashSet = new HashSet<Uri>();
        if (uri2 != null) {
            hashSet.add(uri2);
        }
        for (RegisterRequest zzbej2 : list4) {
            zzbq.checkArgument((uri2 != null || zzbej2.getAppId() != null ? 1 : 0) != 0, (Object)"register request has null appId and no request appId is provided");
            if (zzbej2.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)zzbej2.getAppId()));
        }
        for (RegisteredKey registeredKey : list3) {
            zzbq.checkArgument((uri2 != null || registeredKey.getAppId() != null ? 1 : 0) != 0, (Object)"registered key has null appId and no request appId is provided");
            if (registeredKey.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)registeredKey.getAppId()));
        }
        this.zzgwc = hashSet;
        zzbq.checkArgument((string == null || string.length() <= 80 ? 1 : 0) != 0, (Object)"Display Hint cannot be longer than 80 characters");
        this.zzgwb = string;
    }

    @Override
    public Integer getRequestId() {
        return this.zzgkh;
    }

    @Override
    public Double getTimeoutSeconds() {
        return this.zzgvw;
    }

    @Override
    public Uri getAppId() {
        return this.zzgvx;
    }

    @Override
    public Set<Uri> getAllAppIds() {
        return this.zzgwc;
    }

    public List<RegisterRequest> getRegisterRequests() {
        return this.zzgvy;
    }

    @Override
    public List<RegisteredKey> getRegisteredKeys() {
        return this.zzgvz;
    }

    @Override
    public ChannelIdValue getChannelIdValue() {
        return this.zzgwa;
    }

    @Override
    public String getDisplayHint() {
        return this.zzgwb;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        RegisterRequestParams registerRequestParams = (RegisterRequestParams)((Object)object);
        return zzbg.equal((Object)this.zzgkh, (Object)registerRequestParams.zzgkh) && zzbg.equal((Object)this.zzgvw, (Object)registerRequestParams.zzgvw) && zzbg.equal((Object)this.zzgvx, (Object)registerRequestParams.zzgvx) && zzbg.equal(this.zzgvy, registerRequestParams.zzgvy) && (this.zzgvz == null && registerRequestParams.zzgvz == null || this.zzgvz != null && registerRequestParams.zzgvz != null && this.zzgvz.containsAll(registerRequestParams.zzgvz) && registerRequestParams.zzgvz.containsAll(this.zzgvz)) && zzbg.equal((Object)((Object)this.zzgwa), (Object)((Object)registerRequestParams.zzgwa)) && zzbg.equal((Object)this.zzgwb, (Object)registerRequestParams.zzgwb);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgkh, this.zzgvx, this.zzgvw, this.zzgvy, this.zzgvz, this.zzgwa, this.zzgwb});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RegisterRequestParams registerRequestParams = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)2, (Integer)((RequestParams)registerRequestParams).getRequestId(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)3, (Double)((RequestParams)registerRequestParams).getTimeoutSeconds(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (Parcelable)((RequestParams)registerRequestParams).getAppId(), (int)n, (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)5, registerRequestParams.getRegisterRequests(), (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)6, ((RequestParams)registerRequestParams).getRegisteredKeys(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)7, (Parcelable)((RequestParams)registerRequestParams).getChannelIdValue(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)8, (String)((RequestParams)registerRequestParams).getDisplayHint(), (boolean)false);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private Integer zzgkh;
        private Double zzgvw;
        private Uri zzgvx;
        private List<RegisterRequest> zzgvy;
        private List<RegisteredKey> zzgvz;
        private ChannelIdValue zzgwa;
        private String zzgwb;

        public Builder() {
        }

        public final Builder setRequestId(Integer n) {
            this.zzgkh = n;
            return this;
        }

        public final Builder setTimeoutSeconds(Double d) {
            this.zzgvw = d;
            return this;
        }

        public final Builder setAppId(Uri uri) {
            this.zzgvx = uri;
            return this;
        }

        public final Builder setRegisterRequests(List<RegisterRequest> list) {
            this.zzgvy = list;
            return this;
        }

        public final Builder setRegisteredKeys(List<RegisteredKey> list) {
            this.zzgvz = list;
            return this;
        }

        public final Builder setChannelIdValue(ChannelIdValue channelIdValue) {
            this.zzgwa = channelIdValue;
            return this;
        }

        public final Builder setDisplayHint(String string) {
            this.zzgwb = string;
            return this;
        }

        public final RegisterRequestParams build() {
            return new RegisterRequestParams(this.zzgkh, this.zzgvw, this.zzgvx, this.zzgvy, this.zzgvz, this.zzgwa, this.zzgwb);
        }
    }
}

