/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.u2f.api.common.zzb;
import com.google.android.gms.fido.u2f.api.common.zzc;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import org.json.JSONException;
import org.json.JSONObject;

public class ChannelIdValue
extends zzbfm {
    public static final Parcelable.Creator<ChannelIdValue> CREATOR = new zzc();
    public static final ChannelIdValue ABSENT = new ChannelIdValue();
    public static final ChannelIdValue UNAVAILABLE = new ChannelIdValue("unavailable");
    public static final ChannelIdValue UNUSED = new ChannelIdValue("unused");
    private final ChannelIdValueType zzgxs;
    private final String zzgxt;
    private final String zzgxu;

    ChannelIdValue(int n, String string, String string2) {
        try {
            this.zzgxs = ChannelIdValue.toChannelIdValueType(n);
        }
        catch (UnsupportedChannelIdValueTypeException unsupportedChannelIdValueTypeException) {
            throw new IllegalArgumentException(unsupportedChannelIdValueTypeException);
        }
        this.zzgxt = string;
        this.zzgxu = string2;
    }

    public ChannelIdValue(JSONObject jSONObject) {
        this.zzgxu = (String)zzbq.checkNotNull((Object)jSONObject.toString());
        this.zzgxs = ChannelIdValueType.OBJECT;
        this.zzgxt = null;
    }

    private ChannelIdValue() {
        this.zzgxs = ChannelIdValueType.ABSENT;
        this.zzgxu = null;
        this.zzgxt = null;
    }

    private ChannelIdValue(String string) {
        this.zzgxt = (String)zzbq.checkNotNull((Object)string);
        this.zzgxs = ChannelIdValueType.STRING;
        this.zzgxu = null;
    }

    public static ChannelIdValueType toChannelIdValueType(int n) throws UnsupportedChannelIdValueTypeException {
        for (ChannelIdValueType channelIdValueType : ChannelIdValueType.values()) {
            if (n != channelIdValueType.zzeie) continue;
            return channelIdValueType;
        }
        throw new UnsupportedChannelIdValueTypeException(n);
    }

    public int getTypeAsInt() {
        return this.zzgxs.zzeie;
    }

    public ChannelIdValueType getType() {
        return this.zzgxs;
    }

    public String getObjectValueAsString() {
        return this.zzgxu;
    }

    public JSONObject getObjectValue() {
        if (this.zzgxu == null) {
            return null;
        }
        try {
            return new JSONObject(this.zzgxu);
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public String getStringValue() {
        return this.zzgxt;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ChannelIdValue channelIdValue = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zzc((Parcel)parcel2, (int)2, (int)channelIdValue.getTypeAsInt());
        zzbfp.zza((Parcel)parcel2, (int)3, (String)channelIdValue.getStringValue(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (String)channelIdValue.getObjectValueAsString(), (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ChannelIdValue)) {
            return false;
        }
        ChannelIdValue channelIdValue = (ChannelIdValue)((Object)object);
        if (!this.zzgxs.equals((Object)channelIdValue.zzgxs)) {
            return false;
        }
        switch (this.zzgxs) {
            case ABSENT: {
                return true;
            }
            case STRING: {
                return this.zzgxt.equals(channelIdValue.zzgxt);
            }
            case OBJECT: {
                return this.zzgxu.equals(channelIdValue.zzgxu);
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 31 + this.zzgxs.hashCode();
        switch (this.zzgxs) {
            case ABSENT: {
                break;
            }
            case STRING: {
                n = n * 31 + this.zzgxt.hashCode();
                break;
            }
            case OBJECT: {
                n = n * 31 + this.zzgxu.hashCode();
            }
        }
        return n;
    }

    public static class UnsupportedChannelIdValueTypeException
    extends Exception {
        public UnsupportedChannelIdValueTypeException(int n) {
            super(String.format("ChannelIdValueType %s not supported", n));
        }
    }

    public static enum ChannelIdValueType implements Parcelable
    {
        ABSENT(0),
        STRING(1),
        OBJECT(2);

        public static final Parcelable.Creator<ChannelIdValueType> CREATOR;
        private final int zzeie;

        private ChannelIdValueType(int n2) {
            this.zzeie = n2;
        }

        public final int describeContents() {
            return 0;
        }

        public final void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.zzeie);
        }

        static {
            CREATOR = new zzb();
        }
    }
}

