/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.util.zzb;
import com.google.android.gms.fido.common.Transport;
import com.google.android.gms.fido.u2f.api.common.ProtocolVersion;
import com.google.android.gms.fido.u2f.api.common.zzg;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KeyHandle
extends zzbfm {
    public static final Parcelable.Creator<KeyHandle> CREATOR = new zzg();
    private final int zzeck;
    private final byte[] zzgyc;
    private final ProtocolVersion zzgyd;
    private final List<Transport> zzdpr;

    KeyHandle(int n, byte[] byArray, String string, List<Transport> list) {
        this.zzeck = n;
        this.zzgyc = byArray;
        try {
            this.zzgyd = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new IllegalArgumentException(unsupportedProtocolException);
        }
        this.zzdpr = list;
    }

    public KeyHandle(byte[] byArray, ProtocolVersion protocolVersion, List<Transport> list) {
        this.zzeck = 1;
        this.zzgyc = byArray;
        this.zzgyd = protocolVersion;
        this.zzdpr = list;
    }

    public static KeyHandle parseFromJson(JSONObject jSONObject) throws JSONException {
        byte[] byArray;
        ProtocolVersion protocolVersion;
        String string = null;
        if (jSONObject.has("version")) {
            string = jSONObject.getString("version");
        }
        try {
            protocolVersion = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new JSONException(unsupportedProtocolException.toString());
        }
        String string2 = jSONObject.getString("keyHandle");
        try {
            byArray = Base64.decode((String)string2, (int)8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JSONException(illegalArgumentException.toString());
        }
        JSONObject jSONObject2 = jSONObject;
        List<Transport> list = !jSONObject2.has("transports") ? null : Transport.parseTransports(jSONObject2.getJSONArray("transports"));
        return new KeyHandle(byArray, protocolVersion, list);
    }

    public int getVersionCode() {
        return this.zzeck;
    }

    public byte[] getBytes() {
        return this.zzgyc;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.zzgyd;
    }

    public List<Transport> getTransports() {
        return this.zzdpr;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        KeyHandle keyHandle = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zzc((Parcel)parcel2, (int)1, (int)keyHandle.getVersionCode());
        zzbfp.zza((Parcel)parcel2, (int)2, (byte[])keyHandle.getBytes(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (String)keyHandle.zzgyd.toString(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)4, keyHandle.getTransports(), (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        String string = this.zzdpr == null ? "null" : this.zzdpr.toString();
        return String.format("{keyHandle: %s, version: %s, transports: %s}", new Object[]{zzb.zzk((byte[])this.zzgyc), this.zzgyd, string});
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{Arrays.hashCode(this.zzgyc), this.zzgyd, this.zzdpr});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        KeyHandle keyHandle = (KeyHandle)((Object)object);
        if (!Arrays.equals(this.zzgyc, keyHandle.zzgyc)) {
            return false;
        }
        if (!this.zzgyd.equals((Object)keyHandle.zzgyd)) {
            return false;
        }
        if (this.zzdpr == null && keyHandle.zzdpr == null) {
            return true;
        }
        if (this.zzdpr == null || keyHandle.zzdpr == null) {
            return false;
        }
        return this.zzdpr.containsAll(keyHandle.zzdpr) && keyHandle.zzdpr.containsAll(this.zzdpr);
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.zzgyc != null) {
                jSONObject.put("keyHandle", (Object)Base64.encodeToString((byte[])this.zzgyc, (int)11));
            }
            if (this.zzgyd != null) {
                jSONObject.put("version", (Object)this.zzgyd.toString());
            }
            if (this.zzdpr != null) {
                JSONArray jSONArray = new JSONArray();
                for (Transport transport : this.zzdpr) {
                    jSONArray.put((Object)transport.toString());
                }
                jSONObject.put("transports", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        return jSONObject;
    }
}

