/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.u2f.api.common.ChannelIdValue;
import com.google.android.gms.fido.u2f.api.common.RegisteredKey;
import com.google.android.gms.fido.u2f.api.common.RequestParams;
import com.google.android.gms.fido.u2f.api.common.zzm;
import com.google.android.gms.internal.zzbfp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SignRequestParams
extends RequestParams {
    public static final Parcelable.Creator<SignRequestParams> CREATOR = new zzm();
    public static final int MAX_DISPLAY_HINT_LENGTH = 80;
    private final Integer zzgmr;
    private final Double zzgyg;
    private final Uri zzgyh;
    private final byte[] zzgyr;
    private final List<RegisteredKey> zzgyj;
    private final ChannelIdValue zzgyk;
    private final String zzgyl;
    private final Set<Uri> zzgym;

    SignRequestParams(Integer n, Double d, Uri uri, byte[] byArray, List<RegisteredKey> list, ChannelIdValue channelIdValue, String string) {
        this.zzgmr = n;
        this.zzgyg = d;
        this.zzgyh = uri;
        this.zzgyr = byArray;
        zzbq.checkArgument((list != null && !list.isEmpty() ? 1 : 0) != 0, (Object)"registeredKeys must not be null or empty");
        this.zzgyj = list;
        this.zzgyk = channelIdValue;
        List<RegisteredKey> list2 = list;
        Uri uri2 = uri;
        HashSet<Uri> hashSet = new HashSet<Uri>();
        if (uri2 != null) {
            hashSet.add(uri2);
        }
        for (RegisteredKey registeredKey : list2) {
            zzbq.checkArgument((registeredKey.getAppId() != null || uri2 != null ? 1 : 0) != 0, (Object)"registered key has null appId and no request appId is provided");
            zzbq.checkArgument((registeredKey.getChallengeValue() != null || list2 != null ? 1 : 0) != 0, (Object)"register request has null challenge and no default challenge isprovided");
            if (registeredKey.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)registeredKey.getAppId()));
        }
        this.zzgym = hashSet;
        zzbq.checkArgument((string == null || string.length() <= 80 ? 1 : 0) != 0, (Object)"Display Hint cannot be longer than 80 characters");
        this.zzgyl = string;
    }

    @Override
    public Integer getRequestId() {
        return this.zzgmr;
    }

    @Override
    public Double getTimeoutSeconds() {
        return this.zzgyg;
    }

    @Override
    public Uri getAppId() {
        return this.zzgyh;
    }

    @Override
    public Set<Uri> getAllAppIds() {
        return this.zzgym;
    }

    public byte[] getDefaultSignChallenge() {
        return this.zzgyr;
    }

    @Override
    public List<RegisteredKey> getRegisteredKeys() {
        return this.zzgyj;
    }

    @Override
    public ChannelIdValue getChannelIdValue() {
        return this.zzgyk;
    }

    @Override
    public String getDisplayHint() {
        return this.zzgyl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        SignRequestParams signRequestParams = (SignRequestParams)((Object)object);
        return zzbg.equal((Object)this.zzgmr, (Object)signRequestParams.zzgmr) && zzbg.equal((Object)this.zzgyg, (Object)signRequestParams.zzgyg) && zzbg.equal((Object)this.zzgyh, (Object)signRequestParams.zzgyh) && Arrays.equals(this.zzgyr, signRequestParams.zzgyr) && this.zzgyj.containsAll(signRequestParams.zzgyj) && signRequestParams.zzgyj.containsAll(this.zzgyj) && zzbg.equal((Object)((Object)this.zzgyk), (Object)((Object)signRequestParams.zzgyk)) && zzbg.equal((Object)this.zzgyl, (Object)signRequestParams.zzgyl);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgmr, this.zzgyh, this.zzgyg, this.zzgyj, this.zzgyk, this.zzgyl, Arrays.hashCode(this.zzgyr)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SignRequestParams signRequestParams = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)2, (Integer)((RequestParams)signRequestParams).getRequestId(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (Double)((RequestParams)signRequestParams).getTimeoutSeconds(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (Parcelable)((RequestParams)signRequestParams).getAppId(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)5, (byte[])signRequestParams.getDefaultSignChallenge(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)6, ((RequestParams)signRequestParams).getRegisteredKeys(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)7, (Parcelable)((RequestParams)signRequestParams).getChannelIdValue(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)8, (String)((RequestParams)signRequestParams).getDisplayHint(), (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private Integer zzgmr;
        private Double zzgyg;
        private Uri zzgyh;
        private byte[] zzgyr;
        private List<RegisteredKey> zzgyj;
        private ChannelIdValue zzgyk;
        private String zzgyl;

        public Builder() {
        }

        public final Builder setRequestId(Integer n) {
            this.zzgmr = n;
            return this;
        }

        public final Builder setTimeoutSeconds(Double d) {
            this.zzgyg = d;
            return this;
        }

        public final Builder setAppId(Uri uri) {
            this.zzgyh = uri;
            return this;
        }

        public final Builder setDefaultSignChallenge(byte[] byArray) {
            this.zzgyr = byArray;
            return this;
        }

        public final Builder setRegisteredKeys(List<RegisteredKey> list) {
            this.zzgyj = list;
            return this;
        }

        public final Builder setChannelIdValue(ChannelIdValue channelIdValue) {
            this.zzgyk = channelIdValue;
            return this;
        }

        public final Builder setDisplayHint(String string) {
            this.zzgyl = string;
            return this;
        }

        public final SignRequestParams build() {
            return new SignRequestParams(this.zzgmr, this.zzgyg, this.zzgyh, this.zzgyr, this.zzgyj, this.zzgyk, this.zzgyl);
        }
    }
}

