/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.u2f.api.common.ChannelIdValue;
import com.google.android.gms.fido.u2f.api.common.RegisterRequest;
import com.google.android.gms.fido.u2f.api.common.RegisteredKey;
import com.google.android.gms.fido.u2f.api.common.RequestParams;
import com.google.android.gms.fido.u2f.api.common.zzj;
import com.google.android.gms.internal.zzbfp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RegisterRequestParams
extends RequestParams {
    public static final Parcelable.Creator<RegisterRequestParams> CREATOR = new zzj();
    public static final int MAX_DISPLAY_HINT_LENGTH = 80;
    private final Integer zzgmr;
    private final Double zzgyg;
    private final Uri zzgyh;
    private final List<RegisterRequest> zzgyi;
    private final List<RegisteredKey> zzgyj;
    private final ChannelIdValue zzgyk;
    private final String zzgyl;
    private Set<Uri> zzgym;

    RegisterRequestParams(Integer n, Double d, Uri uri, List<RegisterRequest> list, List<RegisteredKey> list2, ChannelIdValue channelIdValue, String string) {
        this.zzgmr = n;
        this.zzgyg = d;
        this.zzgyh = uri;
        zzbq.checkArgument((list != null && !list.isEmpty() ? 1 : 0) != 0, (Object)"empty list of register requests is provided");
        this.zzgyi = list;
        this.zzgyj = list2;
        this.zzgyk = channelIdValue;
        List<RegisteredKey> list3 = this.zzgyj;
        List<RegisterRequest> list4 = this.zzgyi;
        Uri uri2 = this.zzgyh;
        HashSet<Uri> hashSet = new HashSet<Uri>();
        if (uri2 != null) {
            hashSet.add(uri2);
        }
        for (RegisterRequest zzbfm2 : list4) {
            zzbq.checkArgument((uri2 != null || zzbfm2.getAppId() != null ? 1 : 0) != 0, (Object)"register request has null appId and no request appId is provided");
            if (zzbfm2.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)zzbfm2.getAppId()));
        }
        for (RegisteredKey registeredKey : list3) {
            zzbq.checkArgument((uri2 != null || registeredKey.getAppId() != null ? 1 : 0) != 0, (Object)"registered key has null appId and no request appId is provided");
            if (registeredKey.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)registeredKey.getAppId()));
        }
        this.zzgym = hashSet;
        zzbq.checkArgument((string == null || string.length() <= 80 ? 1 : 0) != 0, (Object)"Display Hint cannot be longer than 80 characters");
        this.zzgyl = string;
    }

    @Override
    public Integer getRequestId() {
        return this.zzgmr;
    }

    @Override
    public Double getTimeoutSeconds() {
        return this.zzgyg;
    }

    @Override
    public Uri getAppId() {
        return this.zzgyh;
    }

    @Override
    public Set<Uri> getAllAppIds() {
        return this.zzgym;
    }

    public List<RegisterRequest> getRegisterRequests() {
        return this.zzgyi;
    }

    @Override
    public List<RegisteredKey> getRegisteredKeys() {
        return this.zzgyj;
    }

    @Override
    public ChannelIdValue getChannelIdValue() {
        return this.zzgyk;
    }

    @Override
    public String getDisplayHint() {
        return this.zzgyl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        RegisterRequestParams registerRequestParams = (RegisterRequestParams)((Object)object);
        return zzbg.equal((Object)this.zzgmr, (Object)registerRequestParams.zzgmr) && zzbg.equal((Object)this.zzgyg, (Object)registerRequestParams.zzgyg) && zzbg.equal((Object)this.zzgyh, (Object)registerRequestParams.zzgyh) && zzbg.equal(this.zzgyi, registerRequestParams.zzgyi) && (this.zzgyj == null && registerRequestParams.zzgyj == null || this.zzgyj != null && registerRequestParams.zzgyj != null && this.zzgyj.containsAll(registerRequestParams.zzgyj) && registerRequestParams.zzgyj.containsAll(this.zzgyj)) && zzbg.equal((Object)((Object)this.zzgyk), (Object)((Object)registerRequestParams.zzgyk)) && zzbg.equal((Object)this.zzgyl, (Object)registerRequestParams.zzgyl);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgmr, this.zzgyh, this.zzgyg, this.zzgyi, this.zzgyj, this.zzgyk, this.zzgyl});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RegisterRequestParams registerRequestParams = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)2, (Integer)((RequestParams)registerRequestParams).getRequestId(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (Double)((RequestParams)registerRequestParams).getTimeoutSeconds(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (Parcelable)((RequestParams)registerRequestParams).getAppId(), (int)n, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)5, registerRequestParams.getRegisterRequests(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)6, ((RequestParams)registerRequestParams).getRegisteredKeys(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)7, (Parcelable)((RequestParams)registerRequestParams).getChannelIdValue(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)8, (String)((RequestParams)registerRequestParams).getDisplayHint(), (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private Integer zzgmr;
        private Double zzgyg;
        private Uri zzgyh;
        private List<RegisterRequest> zzgyi;
        private List<RegisteredKey> zzgyj;
        private ChannelIdValue zzgyk;
        private String zzgyl;

        public Builder() {
        }

        public final Builder setRequestId(Integer n) {
            this.zzgmr = n;
            return this;
        }

        public final Builder setTimeoutSeconds(Double d) {
            this.zzgyg = d;
            return this;
        }

        public final Builder setAppId(Uri uri) {
            this.zzgyh = uri;
            return this;
        }

        public final Builder setRegisterRequests(List<RegisterRequest> list) {
            this.zzgyi = list;
            return this;
        }

        public final Builder setRegisteredKeys(List<RegisteredKey> list) {
            this.zzgyj = list;
            return this;
        }

        public final Builder setChannelIdValue(ChannelIdValue channelIdValue) {
            this.zzgyk = channelIdValue;
            return this;
        }

        public final Builder setDisplayHint(String string) {
            this.zzgyl = string;
            return this;
        }

        public final RegisterRequestParams build() {
            return new RegisterRequestParams(this.zzgmr, this.zzgyg, this.zzgyh, this.zzgyi, this.zzgyj, this.zzgyk, this.zzgyl);
        }
    }
}

