/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.fido.fido2.api.common.zzj;

public enum ErrorCode implements Parcelable
{
    CTAP2_ERR_CREDENTIAL_EXCLUDED(1),
    CTAP2_ERR_UNSUPPORTED_ALGORITHM(2),
    CTAP2_ERR_OPERATION_DENIED(3),
    CTAP2_ERR_OPTION_NOT_SUPPORTED(4),
    CTAP2_ERR_DEVICE_NO_SCREEN_LOCK(5);

    @Hide
    public static final Parcelable.Creator<ErrorCode> CREATOR;
    private final int zza;

    private ErrorCode(int n2) {
        this.zza = n2;
    }

    public static ErrorCode toErrorCode(int n) throws UnsupportedErrorCodeException {
        for (ErrorCode errorCode : ErrorCode.values()) {
            if (n != errorCode.zza) continue;
            return errorCode;
        }
        throw new UnsupportedErrorCodeException(n);
    }

    public final int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.zza);
    }

    public final int getCode() {
        return this.zza;
    }

    static {
        CREATOR = new zzj();
    }

    public static class UnsupportedErrorCodeException
    extends Exception {
        public UnsupportedErrorCodeException(int n) {
            super(String.format("Error code %d is not supported", n));
        }
    }
}

