/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.u2f.api.common.ErrorCode;
import com.google.android.gms.fido.u2f.api.common.ResponseData;
import com.google.android.gms.fido.u2f.api.common.zzf;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class ErrorResponseData
extends ResponseData {
    @Hide
    public static final Parcelable.Creator<ErrorResponseData> CREATOR = new zzf();
    public static final String JSON_ERROR_CODE = "errorCode";
    public static final String JSON_ERROR_MESSAGE = "errorMessage";
    private final ErrorCode zza;
    private final String zzb;

    ErrorResponseData(int n, String string) {
        this.zza = ErrorCode.toErrorCode(n);
        this.zzb = string;
    }

    public ErrorResponseData(ErrorCode errorCode) {
        this.zza = (ErrorCode)((Object)zzbq.zza((Object)((Object)errorCode)));
        this.zzb = null;
    }

    public ErrorResponseData(ErrorCode errorCode, String string) {
        this.zza = (ErrorCode)((Object)zzbq.zza((Object)((Object)errorCode)));
        this.zzb = string;
    }

    public ErrorCode getErrorCode() {
        return this.zza;
    }

    public int getErrorCodeAsInt() {
        return this.zza.getCode();
    }

    public String getErrorMessage() {
        return this.zzb;
    }

    public String toString() {
        if (this.zzb == null) {
            return String.format(Locale.ENGLISH, "{errorCode: %d}", this.zza.getCode());
        }
        return String.format(Locale.ENGLISH, "{errorCode: %d, errorMessage: %s}", this.zza.getCode(), this.zzb);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        ErrorResponseData errorResponseData = (ErrorResponseData)((Object)object);
        return zzbg.zza((Object)((Object)this.zza), (Object)((Object)errorResponseData.zza)) && zzbg.zza((Object)this.zzb, (Object)errorResponseData.zzb);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzb});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ErrorResponseData errorResponseData = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (int)errorResponseData.getErrorCodeAsInt());
        zzbgo.zza((Parcel)parcel2, (int)3, (String)errorResponseData.getErrorMessage(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    @Override
    public JSONObject toJsonObject() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(JSON_ERROR_CODE, this.zza.getCode());
            if (this.zzb != null) {
                jSONObject.put(JSON_ERROR_MESSAGE, (Object)this.zzb);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }
}

