/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.u2f.api.common.ChannelIdValue;
import com.google.android.gms.fido.u2f.api.common.RegisterRequest;
import com.google.android.gms.fido.u2f.api.common.RegisteredKey;
import com.google.android.gms.fido.u2f.api.common.RequestParams;
import com.google.android.gms.fido.u2f.api.common.zzj;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RegisterRequestParams
extends RequestParams {
    @Hide
    public static final Parcelable.Creator<RegisterRequestParams> CREATOR = new zzj();
    public static final int MAX_DISPLAY_HINT_LENGTH = 80;
    private final Integer zza;
    private final Double zzb;
    private final Uri zzc;
    private final List<RegisterRequest> zzd;
    private final List<RegisteredKey> zze;
    private final ChannelIdValue zzf;
    private final String zzg;
    private Set<Uri> zzh;

    RegisterRequestParams(Integer n, Double d, Uri uri, List<RegisterRequest> list, List<RegisteredKey> list2, ChannelIdValue channelIdValue, String string) {
        this.zza = n;
        this.zzb = d;
        this.zzc = uri;
        zzbq.zzb((list != null && !list.isEmpty() ? 1 : 0) != 0, (Object)"empty list of register requests is provided");
        this.zzd = list;
        this.zze = list2;
        this.zzf = channelIdValue;
        List<RegisteredKey> list3 = this.zze;
        List<RegisterRequest> list4 = this.zzd;
        Uri uri2 = this.zzc;
        HashSet<Uri> hashSet = new HashSet<Uri>();
        if (uri2 != null) {
            hashSet.add(uri2);
        }
        for (RegisterRequest zzbgl2 : list4) {
            zzbq.zzb((uri2 != null || zzbgl2.getAppId() != null ? 1 : 0) != 0, (Object)"register request has null appId and no request appId is provided");
            if (zzbgl2.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)zzbgl2.getAppId()));
        }
        for (RegisteredKey registeredKey : list3) {
            zzbq.zzb((uri2 != null || registeredKey.getAppId() != null ? 1 : 0) != 0, (Object)"registered key has null appId and no request appId is provided");
            if (registeredKey.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)registeredKey.getAppId()));
        }
        this.zzh = hashSet;
        zzbq.zzb((string == null || string.length() <= 80 ? 1 : 0) != 0, (Object)"Display Hint cannot be longer than 80 characters");
        this.zzg = string;
    }

    @Override
    public Integer getRequestId() {
        return this.zza;
    }

    @Override
    public Double getTimeoutSeconds() {
        return this.zzb;
    }

    @Override
    public Uri getAppId() {
        return this.zzc;
    }

    @Override
    public Set<Uri> getAllAppIds() {
        return this.zzh;
    }

    public List<RegisterRequest> getRegisterRequests() {
        return this.zzd;
    }

    @Override
    public List<RegisteredKey> getRegisteredKeys() {
        return this.zze;
    }

    @Override
    public ChannelIdValue getChannelIdValue() {
        return this.zzf;
    }

    @Override
    public String getDisplayHint() {
        return this.zzg;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        RegisterRequestParams registerRequestParams = (RegisterRequestParams)((Object)object);
        return zzbg.zza((Object)this.zza, (Object)registerRequestParams.zza) && zzbg.zza((Object)this.zzb, (Object)registerRequestParams.zzb) && zzbg.zza((Object)this.zzc, (Object)registerRequestParams.zzc) && zzbg.zza(this.zzd, registerRequestParams.zzd) && (this.zze == null && registerRequestParams.zze == null || this.zze != null && registerRequestParams.zze != null && this.zze.containsAll(registerRequestParams.zze) && registerRequestParams.zze.containsAll(this.zze)) && zzbg.zza((Object)((Object)this.zzf), (Object)((Object)registerRequestParams.zzf)) && zzbg.zza((Object)this.zzg, (Object)registerRequestParams.zzg);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzc, this.zzb, this.zzd, this.zze, this.zzf, this.zzg});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RegisterRequestParams registerRequestParams = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (Integer)((RequestParams)registerRequestParams).getRequestId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (Double)((RequestParams)registerRequestParams).getTimeoutSeconds(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (Parcelable)((RequestParams)registerRequestParams).getAppId(), (int)n, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)5, registerRequestParams.getRegisterRequests(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)6, ((RequestParams)registerRequestParams).getRegisteredKeys(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (Parcelable)((RequestParams)registerRequestParams).getChannelIdValue(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (String)((RequestParams)registerRequestParams).getDisplayHint(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private Integer zza;
        private Double zzb;
        private Uri zzc;
        private List<RegisterRequest> zzd;
        private List<RegisteredKey> zze;
        private ChannelIdValue zzf;
        private String zzg;

        public Builder() {
        }

        public final Builder setRequestId(Integer n) {
            this.zza = n;
            return this;
        }

        public final Builder setTimeoutSeconds(Double d) {
            this.zzb = d;
            return this;
        }

        public final Builder setAppId(Uri uri) {
            this.zzc = uri;
            return this;
        }

        public final Builder setRegisterRequests(List<RegisterRequest> list) {
            this.zzd = list;
            return this;
        }

        public final Builder setRegisteredKeys(List<RegisteredKey> list) {
            this.zze = list;
            return this;
        }

        public final Builder setChannelIdValue(ChannelIdValue channelIdValue) {
            this.zzf = channelIdValue;
            return this;
        }

        public final Builder setDisplayHint(String string) {
            this.zzg = string;
            return this;
        }

        public final RegisterRequestParams build() {
            return new RegisterRequestParams(this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg);
        }
    }
}

