/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.u2f.api.common.ProtocolVersion;
import com.google.android.gms.fido.u2f.api.common.zzi;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public class RegisterRequest
extends zzbgl {
    @Hide
    public static final Parcelable.Creator<RegisterRequest> CREATOR = new zzi();
    public static final int U2F_V1_CHALLENGE_BYTE_LENGTH = 65;
    private final int zzehz;
    private final ProtocolVersion zzhgj;
    private final byte[] zzhgl;
    private final String mAppId;

    RegisterRequest(int n, String string, byte[] byArray, String string2) {
        this.zzehz = n;
        try {
            this.zzhgj = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new IllegalArgumentException(unsupportedProtocolException);
        }
        this.zzhgl = byArray;
        this.mAppId = string2;
    }

    public RegisterRequest(ProtocolVersion protocolVersion, byte[] byArray, String string) {
        this.zzehz = 1;
        this.zzhgj = (ProtocolVersion)((Object)zzbq.checkNotNull((Object)((Object)protocolVersion)));
        this.zzhgl = (byte[])zzbq.checkNotNull((Object)byArray);
        if (protocolVersion == ProtocolVersion.V1) {
            zzbq.checkArgument((byArray.length == 65 ? 1 : 0) != 0, (Object)"invalid challengeValue length for V1");
        }
        this.mAppId = string;
    }

    public static RegisterRequest parseFromJson(JSONObject jSONObject) throws JSONException {
        byte[] byArray;
        ProtocolVersion protocolVersion;
        String string = null;
        if (jSONObject.has("version")) {
            string = jSONObject.getString("version");
        }
        try {
            protocolVersion = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new JSONException(unsupportedProtocolException.toString());
        }
        String string2 = jSONObject.getString("challenge");
        try {
            byArray = Base64.decode((String)string2, (int)8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JSONException(illegalArgumentException.toString());
        }
        String string3 = null;
        if (jSONObject.has("appId")) {
            string3 = jSONObject.getString("appId");
        }
        try {
            return new RegisterRequest(protocolVersion, byArray, string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JSONException(illegalArgumentException.getMessage());
        }
    }

    public int getVersionCode() {
        return this.zzehz;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.zzhgj;
    }

    public byte[] getChallengeValue() {
        return this.zzhgl;
    }

    public String getAppId() {
        return this.mAppId;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RegisterRequest registerRequest = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)1, (int)registerRequest.getVersionCode());
        zzbgo.zza((Parcel)parcel2, (int)2, (String)registerRequest.zzhgj.toString(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (byte[])registerRequest.getChallengeValue(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (String)registerRequest.getAppId(), (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        int n = 31 + Arrays.hashCode(this.zzhgl);
        n = n * 31 + this.zzhgj.hashCode();
        return n * 31 + (this.mAppId == null ? 0 : this.mAppId.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        RegisterRequest registerRequest = (RegisterRequest)((Object)object);
        if (!Arrays.equals(this.zzhgl, registerRequest.zzhgl)) {
            return false;
        }
        if (this.zzhgj != registerRequest.zzhgj) {
            return false;
        }
        return !(this.mAppId == null ? registerRequest.mAppId != null : !this.mAppId.equals(registerRequest.mAppId));
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("version", (Object)this.zzhgj.toString());
            jSONObject.put("challenge", (Object)Base64.encodeToString((byte[])this.zzhgl, (int)11));
            if (this.mAppId != null) {
                jSONObject.put("appId", (Object)this.mAppId);
            }
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        return jSONObject;
    }
}

