/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.fido2.api.common.zzs;
import com.google.android.gms.fido.fido2.api.common.zzt;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import org.json.JSONException;
import org.json.JSONObject;

public class TokenBindingIdValue
extends zzbgl {
    @Hide
    public static final Parcelable.Creator<TokenBindingIdValue> CREATOR = new zzt();
    public static final TokenBindingIdValue ABSENT = new TokenBindingIdValue();
    public static final TokenBindingIdValue UNAVAILABLE = new TokenBindingIdValue("unavailable");
    public static final TokenBindingIdValue UNUSED = new TokenBindingIdValue("unused");
    private final TokenBindingIdValueType zzhfr;
    private final String zzhfs;
    private final String zzhft;

    TokenBindingIdValue(int n, String string, String string2) {
        try {
            this.zzhfr = TokenBindingIdValue.toTokenBindingIdValueType(n);
        }
        catch (UnsupportedTokenBindingIdValueTypeException unsupportedTokenBindingIdValueTypeException) {
            throw new IllegalArgumentException(unsupportedTokenBindingIdValueTypeException);
        }
        this.zzhfs = string;
        this.zzhft = string2;
    }

    public TokenBindingIdValue(JSONObject jSONObject) {
        this.zzhft = (String)zzbq.checkNotNull((Object)jSONObject.toString());
        this.zzhfr = TokenBindingIdValueType.OBJECT;
        this.zzhfs = null;
    }

    private TokenBindingIdValue() {
        this.zzhfr = TokenBindingIdValueType.ABSENT;
        this.zzhft = null;
        this.zzhfs = null;
    }

    private TokenBindingIdValue(String string) {
        this.zzhfs = (String)zzbq.checkNotNull((Object)string);
        this.zzhfr = TokenBindingIdValueType.STRING;
        this.zzhft = null;
    }

    public static TokenBindingIdValueType toTokenBindingIdValueType(int n) throws UnsupportedTokenBindingIdValueTypeException {
        for (TokenBindingIdValueType tokenBindingIdValueType : TokenBindingIdValueType.values()) {
            if (n != tokenBindingIdValueType.zzenu) continue;
            return tokenBindingIdValueType;
        }
        throw new UnsupportedTokenBindingIdValueTypeException(n);
    }

    public int getTypeAsInt() {
        return this.zzhfr.zzenu;
    }

    public TokenBindingIdValueType getType() {
        return this.zzhfr;
    }

    public String getObjectValueAsString() {
        return this.zzhft;
    }

    public JSONObject getObjectValue() {
        if (this.zzhft == null) {
            return null;
        }
        try {
            return new JSONObject(this.zzhft);
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public String getStringValue() {
        return this.zzhfs;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        TokenBindingIdValue tokenBindingIdValue = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)2, (int)tokenBindingIdValue.getTypeAsInt());
        zzbgo.zza((Parcel)parcel2, (int)3, (String)tokenBindingIdValue.getStringValue(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (String)tokenBindingIdValue.getObjectValueAsString(), (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TokenBindingIdValue)) {
            return false;
        }
        TokenBindingIdValue tokenBindingIdValue = (TokenBindingIdValue)((Object)object);
        if (!this.zzhfr.equals((Object)tokenBindingIdValue.zzhfr)) {
            return false;
        }
        switch (this.zzhfr) {
            case ABSENT: {
                return true;
            }
            case STRING: {
                return this.zzhfs.equals(tokenBindingIdValue.zzhfs);
            }
            case OBJECT: {
                return this.zzhft.equals(tokenBindingIdValue.zzhft);
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 31 + this.zzhfr.hashCode();
        switch (this.zzhfr) {
            case ABSENT: {
                break;
            }
            case STRING: {
                n = n * 31 + this.zzhfs.hashCode();
                break;
            }
            case OBJECT: {
                n = n * 31 + this.zzhft.hashCode();
            }
        }
        return n;
    }

    public static class UnsupportedTokenBindingIdValueTypeException
    extends Exception {
        public UnsupportedTokenBindingIdValueTypeException(int n) {
            super(String.format("TokenBindingIdValueType %s not supported", n));
        }
    }

    public static enum TokenBindingIdValueType implements Parcelable
    {
        ABSENT(0),
        STRING(1),
        OBJECT(2);

        public static final Parcelable.Creator<TokenBindingIdValueType> CREATOR;
        private final int zzenu;

        private TokenBindingIdValueType(int n2) {
            this.zzenu = n2;
        }

        public final int describeContents() {
            return 0;
        }

        public final void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.zzenu);
        }

        static {
            CREATOR = new zzs();
        }
    }
}

