/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.u2f.api.common.zzb;
import com.google.android.gms.fido.u2f.api.common.zzc;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import org.json.JSONException;
import org.json.JSONObject;

public class ChannelIdValue
extends zzbgl {
    @Hide
    public static final Parcelable.Creator<ChannelIdValue> CREATOR = new zzc();
    public static final ChannelIdValue ABSENT = new ChannelIdValue();
    public static final ChannelIdValue UNAVAILABLE = new ChannelIdValue("unavailable");
    public static final ChannelIdValue UNUSED = new ChannelIdValue("unused");
    private final ChannelIdValueType zzhgb;
    private final String zzhfs;
    private final String zzhft;

    ChannelIdValue(int n, String string, String string2) {
        try {
            this.zzhgb = ChannelIdValue.toChannelIdValueType(n);
        }
        catch (UnsupportedChannelIdValueTypeException unsupportedChannelIdValueTypeException) {
            throw new IllegalArgumentException(unsupportedChannelIdValueTypeException);
        }
        this.zzhfs = string;
        this.zzhft = string2;
    }

    public ChannelIdValue(JSONObject jSONObject) {
        this.zzhft = (String)zzbq.checkNotNull((Object)jSONObject.toString());
        this.zzhgb = ChannelIdValueType.OBJECT;
        this.zzhfs = null;
    }

    private ChannelIdValue() {
        this.zzhgb = ChannelIdValueType.ABSENT;
        this.zzhft = null;
        this.zzhfs = null;
    }

    private ChannelIdValue(String string) {
        this.zzhfs = (String)zzbq.checkNotNull((Object)string);
        this.zzhgb = ChannelIdValueType.STRING;
        this.zzhft = null;
    }

    public static ChannelIdValueType toChannelIdValueType(int n) throws UnsupportedChannelIdValueTypeException {
        for (ChannelIdValueType channelIdValueType : ChannelIdValueType.values()) {
            if (n != channelIdValueType.zzenu) continue;
            return channelIdValueType;
        }
        throw new UnsupportedChannelIdValueTypeException(n);
    }

    public int getTypeAsInt() {
        return this.zzhgb.zzenu;
    }

    public ChannelIdValueType getType() {
        return this.zzhgb;
    }

    public String getObjectValueAsString() {
        return this.zzhft;
    }

    public JSONObject getObjectValue() {
        if (this.zzhft == null) {
            return null;
        }
        try {
            return new JSONObject(this.zzhft);
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public String getStringValue() {
        return this.zzhfs;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ChannelIdValue channelIdValue = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)2, (int)channelIdValue.getTypeAsInt());
        zzbgo.zza((Parcel)parcel2, (int)3, (String)channelIdValue.getStringValue(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (String)channelIdValue.getObjectValueAsString(), (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ChannelIdValue)) {
            return false;
        }
        ChannelIdValue channelIdValue = (ChannelIdValue)((Object)object);
        if (!this.zzhgb.equals((Object)channelIdValue.zzhgb)) {
            return false;
        }
        switch (this.zzhgb) {
            case ABSENT: {
                return true;
            }
            case STRING: {
                return this.zzhfs.equals(channelIdValue.zzhfs);
            }
            case OBJECT: {
                return this.zzhft.equals(channelIdValue.zzhft);
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 31 + this.zzhgb.hashCode();
        switch (this.zzhgb) {
            case ABSENT: {
                break;
            }
            case STRING: {
                n = n * 31 + this.zzhfs.hashCode();
                break;
            }
            case OBJECT: {
                n = n * 31 + this.zzhft.hashCode();
            }
        }
        return n;
    }

    public static class UnsupportedChannelIdValueTypeException
    extends Exception {
        public UnsupportedChannelIdValueTypeException(int n) {
            super(String.format("ChannelIdValueType %s not supported", n));
        }
    }

    public static enum ChannelIdValueType implements Parcelable
    {
        ABSENT(0),
        STRING(1),
        OBJECT(2);

        public static final Parcelable.Creator<ChannelIdValueType> CREATOR;
        private final int zzenu;

        private ChannelIdValueType(int n2) {
            this.zzenu = n2;
        }

        public final int describeContents() {
            return 0;
        }

        public final void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.zzenu);
        }

        static {
            CREATOR = new zzb();
        }
    }
}

