/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.u2f.api.common.ChannelIdValue;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientData {
    public static final String KEY_TYPE = "typ";
    public static final String KEY_CHALLENGE = "challenge";
    public static final String KEY_ORIGIN = "origin";
    public static final String KEY_CID_PUBKEY = "cid_pubkey";
    public static final String TYPE_FINISH_ENROLLMENT = "navigator.id.finishEnrollment";
    public static final String TYPE_GET_ASSERTION = "navigator.id.getAssertion";
    private final String zzczr;
    private final String zzhge;
    private final String mOrigin;
    private final ChannelIdValue zzhgf;

    ClientData(String string, String string2, String string3, ChannelIdValue channelIdValue) {
        this.zzczr = (String)zzbq.checkNotNull((Object)string);
        this.zzhge = (String)zzbq.checkNotNull((Object)string2);
        this.mOrigin = (String)zzbq.checkNotNull((Object)string3);
        this.zzhgf = (ChannelIdValue)((Object)zzbq.checkNotNull((Object)((Object)channelIdValue)));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ClientData)) {
            return false;
        }
        ClientData clientData = (ClientData)object;
        return this.zzczr.equals(clientData.zzczr) && this.zzhge.equals(clientData.zzhge) && this.mOrigin.equals(clientData.mOrigin) && this.zzhgf.equals((Object)clientData.zzhgf);
    }

    public int hashCode() {
        int n = 31 + this.zzczr.hashCode();
        n = n * 31 + this.zzhge.hashCode();
        n = n * 31 + this.mOrigin.hashCode();
        return n * 31 + this.zzhgf.hashCode();
    }

    public String toJsonString() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(KEY_TYPE, (Object)this.zzczr);
            jSONObject.put(KEY_CHALLENGE, (Object)this.zzhge);
            jSONObject.put(KEY_ORIGIN, (Object)this.mOrigin);
            switch (this.zzhgf.getType()) {
                case ABSENT: {
                    break;
                }
                case STRING: {
                    jSONObject.put(KEY_CID_PUBKEY, (Object)this.zzhgf.getStringValue());
                    break;
                }
                case OBJECT: {
                    jSONObject.put(KEY_CID_PUBKEY, (Object)this.zzhgf.getObjectValue());
                }
            }
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        return jSONObject.toString();
    }

    public static class Builder
    implements Cloneable {
        private String zzczr;
        private String zzhge;
        private String mOrigin;
        private ChannelIdValue zzhgf;

        Builder() {
            this.zzhgf = ChannelIdValue.ABSENT;
        }

        private Builder(String string, String string2, String string3, ChannelIdValue channelIdValue) {
            this.zzczr = string;
            this.zzhge = string2;
            this.mOrigin = string3;
            this.zzhgf = channelIdValue;
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder setType(String string) {
            this.zzczr = string;
            return this;
        }

        public Builder setChallenge(String string) {
            this.zzhge = string;
            return this;
        }

        public Builder setOrigin(String string) {
            this.mOrigin = string;
            return this;
        }

        public Builder setChannelId(ChannelIdValue channelIdValue) {
            this.zzhgf = channelIdValue;
            return this;
        }

        public Builder clone() {
            return new Builder(this.zzczr, this.zzhge, this.mOrigin, this.zzhgf);
        }

        public ClientData build() {
            return new ClientData(this.zzczr, this.zzhge, this.mOrigin, this.zzhgf);
        }
    }
}

