/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.u2f.api.common.ErrorCode;
import com.google.android.gms.fido.u2f.api.common.ResponseData;
import com.google.android.gms.fido.u2f.api.common.zzf;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class ErrorResponseData
extends ResponseData {
    @Hide
    public static final Parcelable.Creator<ErrorResponseData> CREATOR = new zzf();
    public static final String JSON_ERROR_CODE = "errorCode";
    public static final String JSON_ERROR_MESSAGE = "errorMessage";
    private final ErrorCode zzhgg;
    private final String mErrorMessage;

    ErrorResponseData(int n, String string) {
        this.zzhgg = ErrorCode.toErrorCode(n);
        this.mErrorMessage = string;
    }

    public ErrorResponseData(ErrorCode errorCode) {
        this.zzhgg = (ErrorCode)((Object)zzbq.checkNotNull((Object)((Object)errorCode)));
        this.mErrorMessage = null;
    }

    public ErrorResponseData(ErrorCode errorCode, String string) {
        this.zzhgg = (ErrorCode)((Object)zzbq.checkNotNull((Object)((Object)errorCode)));
        this.mErrorMessage = string;
    }

    public ErrorCode getErrorCode() {
        return this.zzhgg;
    }

    public int getErrorCodeAsInt() {
        return this.zzhgg.getCode();
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public String toString() {
        if (this.mErrorMessage == null) {
            return String.format(Locale.ENGLISH, "{errorCode: %d}", this.zzhgg.getCode());
        }
        return String.format(Locale.ENGLISH, "{errorCode: %d, errorMessage: %s}", this.zzhgg.getCode(), this.mErrorMessage);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        ErrorResponseData errorResponseData = (ErrorResponseData)((Object)object);
        return zzbg.equal((Object)((Object)this.zzhgg), (Object)((Object)errorResponseData.zzhgg)) && zzbg.equal((Object)this.mErrorMessage, (Object)errorResponseData.mErrorMessage);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhgg, this.mErrorMessage});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ErrorResponseData errorResponseData = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)2, (int)errorResponseData.getErrorCodeAsInt());
        zzbgo.zza((Parcel)parcel2, (int)3, (String)errorResponseData.getErrorMessage(), (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    @Override
    public JSONObject toJsonObject() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(JSON_ERROR_CODE, this.zzhgg.getCode());
            if (this.mErrorMessage != null) {
                jSONObject.put(JSON_ERROR_MESSAGE, (Object)this.mErrorMessage);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }
}

