/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.fido.u2f.api.common.zzh;
import java.io.UnsupportedEncodingException;

public enum ProtocolVersion implements Parcelable
{
    UNKNOWN("UNKNOWN"),
    V1("U2F_V1"),
    V2("U2F_V2");

    @Hide
    public static final Parcelable.Creator<ProtocolVersion> CREATOR;
    private final String mValue;

    private ProtocolVersion(String string2) {
        this.mValue = string2;
    }

    public static ProtocolVersion fromString(String string) throws UnsupportedProtocolException {
        if (string == null) {
            return UNKNOWN;
        }
        for (ProtocolVersion protocolVersion : ProtocolVersion.values()) {
            if (!string.equals(protocolVersion.mValue)) continue;
            return protocolVersion;
        }
        throw new UnsupportedProtocolException(string);
    }

    public static ProtocolVersion fromBytes(byte[] byArray) throws UnsupportedProtocolException {
        String string;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        return ProtocolVersion.fromString(string);
    }

    public final String toString() {
        return this.mValue;
    }

    public final int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mValue);
    }

    public final boolean isCompatible(ProtocolVersion protocolVersion) {
        if (this.equals((Object)UNKNOWN) || protocolVersion.equals((Object)UNKNOWN)) {
            return true;
        }
        return this.equals((Object)protocolVersion);
    }

    static {
        CREATOR = new zzh();
    }

    public static class UnsupportedProtocolException
    extends Exception {
        public UnsupportedProtocolException(String string) {
            super(String.format("Protocol version %s not supported", string));
        }
    }
}

