/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fido.fido2.api.common.Attachment;
import com.google.android.gms.fido.fido2.api.common.ResidentKeyRequirement;
import com.google.android.gms.fido.fido2.api.common.zzas;
import com.google.android.gms.fido.fido2.api.common.zzat;
import com.google.android.gms.fido.fido2.api.common.zzj;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="AuthenticatorSelectionCriteriaCreator")
public class AuthenticatorSelectionCriteria
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<AuthenticatorSelectionCriteria> CREATOR = new zzj();
    @Nullable
    @SafeParcelable.Field(id=2, getter="getAttachmentAsString", type="java.lang.String")
    private final Attachment zza;
    @Nullable
    @SafeParcelable.Field(id=3, getter="getRequireResidentKey")
    private final Boolean zzb;
    @Nullable
    @SafeParcelable.Field(id=4, getter="getRequireUserVerificationAsString", type="java.lang.String")
    private final zzat zzc;
    @Nullable
    @SafeParcelable.Field(id=5, getter="getResidentKeyRequirementAsString", type="java.lang.String")
    private final ResidentKeyRequirement zzd;

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzb, this.zzc, this.zzd});
    }

    @Nullable
    public Attachment getAttachment() {
        return this.zza;
    }

    @Nullable
    public ResidentKeyRequirement getResidentKeyRequirement() {
        return this.zzd;
    }

    @Nullable
    public Boolean getRequireResidentKey() {
        return this.zzb;
    }

    @Nullable
    public String getAttachmentAsString() {
        Object this_ = this_.zza;
        if (this_ == null) {
            return null;
        }
        return ((Attachment)((Object)this_)).toString();
    }

    @Nullable
    public String getResidentKeyRequirementAsString() {
        Object this_ = this_.zzd;
        if (this_ == null) {
            return null;
        }
        return ((ResidentKeyRequirement)((Object)this_)).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SafeParcelable.Constructor
    AuthenticatorSelectionCriteria(@Nullable @SafeParcelable.Param(id=2) String object, @Nullable @SafeParcelable.Param(id=3) Boolean bl, @Nullable @SafeParcelable.Param(id=4) String string, @Nullable @SafeParcelable.Param(id=5) String string2) {
        if (object == null) {
            object = null;
        } else {
            object = Attachment.fromString(object);
        }
        try {
            this.zza = object;
            this.zzb = bl;
            object = string == null ? null : zzat.zza(string);
            this.zzc = object;
            object = string2 == null ? null : ResidentKeyRequirement.fromString(string2);
            this.zzd = object;
            return;
        }
        catch (Attachment.UnsupportedAttachmentException | ResidentKeyRequirement.UnsupportedResidentKeyRequirementException | zzas exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var2_5;
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getAttachmentAsString(), (boolean)false);
        SafeParcelWriter.writeBooleanObject((Parcel)var1_1, (int)3, (Boolean)this.getRequireResidentKey(), (boolean)false);
        zzat zzat2 = this.zzc;
        if (zzat2 == null) {
            Object var2_4 = null;
        } else {
            String string = zzat2.toString();
        }
        SafeParcelWriter.writeString((Parcel)var1_1, (int)4, (String)var2_5, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.getResidentKeyRequirementAsString(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n2);
    }

    public boolean equals(@NonNull Object obj) {
        AuthenticatorSelectionCriteria authenticatorSelectionCriteria;
        if (!(obj instanceof AuthenticatorSelectionCriteria)) {
            return false;
        }
        authenticatorSelectionCriteria = authenticatorSelectionCriteria;
        return Objects.equal((Object)((Object)this.zza), (Object)((Object)authenticatorSelectionCriteria.zza)) && Objects.equal((Object)this.zzb, (Object)authenticatorSelectionCriteria.zzb) && Objects.equal((Object)((Object)this.zzc), (Object)((Object)authenticatorSelectionCriteria.zzc)) && Objects.equal((Object)((Object)this.zzd), (Object)((Object)authenticatorSelectionCriteria.zzd));
    }

    public static class Builder {
        private Attachment zza;
        private Boolean zzb;
        private ResidentKeyRequirement zzc;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAttachment(@Nullable Attachment attachment) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRequireResidentKey(@Nullable Boolean requireResidentKey) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setResidentKeyRequirement(@Nullable ResidentKeyRequirement residentKeyRequirement) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public AuthenticatorSelectionCriteria build() {
            void var0_3;
            void var1_8;
            Attachment attachment = this.zza;
            if (attachment == null) {
                Object var1_7 = null;
            } else {
                String string = attachment.toString();
            }
            Boolean bl = this.zzb;
            ResidentKeyRequirement residentKeyRequirement = this.zzc;
            if (residentKeyRequirement == null) {
                Object var0_2 = null;
                return new AuthenticatorSelectionCriteria((String)var1_8, bl, null, (String)var0_3);
            } else {
                String string = residentKeyRequirement.toString();
            }
            return new AuthenticatorSelectionCriteria((String)var1_8, bl, null, (String)var0_3);
        }
    }
}

