/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.fido.fido2.api.common.AuthenticationExtensions;
import com.google.android.gms.fido.fido2.api.common.BrowserRequestOptions;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialCreationOptions;
import com.google.android.gms.fido.fido2.api.common.TokenBinding;
import com.google.android.gms.fido.fido2.api.common.zzk;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="BrowserPublicKeyCredentialCreationOptionsCreator")
public class BrowserPublicKeyCredentialCreationOptions
extends BrowserRequestOptions {
    @NonNull
    public static final Parcelable.Creator<BrowserPublicKeyCredentialCreationOptions> CREATOR = new zzk();
    @NonNull
    @SafeParcelable.Field(id=2, getter="getPublicKeyCredentialCreationOptions")
    private final PublicKeyCredentialCreationOptions zza;
    @NonNull
    @SafeParcelable.Field(id=3, getter="getOrigin")
    private final Uri zzb;
    @Nullable
    @SafeParcelable.Field(id=4, getter="getClientDataHash")
    private final byte[] zzc;

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzb});
    }

    @Override
    @NonNull
    public Uri getOrigin() {
        return this.zzb;
    }

    @Override
    @Nullable
    public AuthenticationExtensions getAuthenticationExtensions() {
        return this.zza.getAuthenticationExtensions();
    }

    @NonNull
    public static BrowserPublicKeyCredentialCreationOptions deserializeFromBytes(@NonNull byte[] serializedBytes) {
        return (BrowserPublicKeyCredentialCreationOptions)SafeParcelableSerializer.deserializeFromBytes((byte[])serializedBytes, CREATOR);
    }

    @NonNull
    public PublicKeyCredentialCreationOptions getPublicKeyCredentialCreationOptions() {
        return this.zza;
    }

    @Override
    @Nullable
    public TokenBinding getTokenBinding() {
        return this.zza.getTokenBinding();
    }

    @Override
    @Nullable
    public Double getTimeoutSeconds() {
        return this.zza.getTimeoutSeconds();
    }

    @Override
    @Nullable
    public Integer getRequestId() {
        return this.zza.getRequestId();
    }

    @SafeParcelable.Constructor
    BrowserPublicKeyCredentialCreationOptions(@NonNull @SafeParcelable.Param(id=2) PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions, @NonNull @SafeParcelable.Param(id=3) Uri uri, @Nullable @SafeParcelable.Param(id=4) byte[] byArray) {
        this.zza = (PublicKeyCredentialCreationOptions)((Object)Preconditions.checkNotNull((Object)((Object)publicKeyCredentialCreationOptions)));
        BrowserPublicKeyCredentialCreationOptions.zzc(uri);
        this.zzb = uri;
        BrowserPublicKeyCredentialCreationOptions.zzd(byArray);
        this.zzc = byArray;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)this.getPublicKeyCredentialCreationOptions(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)3, (Parcelable)this.getOrigin(), (int)var2_2, (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeByteArray((Parcel)v1, (int)4, (byte[])this.getClientDataHash(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    public boolean equals(@NonNull Object obj) {
        BrowserPublicKeyCredentialCreationOptions browserPublicKeyCredentialCreationOptions;
        if (!(obj instanceof BrowserPublicKeyCredentialCreationOptions)) {
            return false;
        }
        browserPublicKeyCredentialCreationOptions = browserPublicKeyCredentialCreationOptions;
        return Objects.equal((Object)((Object)this.zza), (Object)((Object)browserPublicKeyCredentialCreationOptions.zza)) && Objects.equal((Object)this.zzb, (Object)browserPublicKeyCredentialCreationOptions.zzb);
    }

    @Override
    @NonNull
    public byte[] getChallenge() {
        return this.zza.getChallenge();
    }

    @Override
    @NonNull
    public byte[] getClientDataHash() {
        return this.zzc;
    }

    @Override
    @NonNull
    public byte[] serializeToBytes() {
        return SafeParcelableSerializer.serializeToBytes((SafeParcelable)this);
    }

    static /* bridge */ /* synthetic */ Uri zza(Uri uri) {
        BrowserPublicKeyCredentialCreationOptions.zzc(uri);
        return uri;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Uri zzc(Uri uri) {
        Preconditions.checkNotNull((Object)uri);
        boolean bl = uri.getScheme() != null;
        Preconditions.checkArgument((boolean)bl, (Object)"origin scheme must be non-empty");
        bl = uri.getAuthority() != null;
        Preconditions.checkArgument((boolean)bl, (Object)"origin authority must be non-empty");
        return uri;
    }

    static /* bridge */ /* synthetic */ byte[] zzb(byte[] byArray) {
        BrowserPublicKeyCredentialCreationOptions.zzd(byArray);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static byte[] zzd(byte[] byArray) {
        boolean bl = byArray != null ? byArray.length == 32 : true;
        Preconditions.checkArgument((boolean)bl, (Object)"clientDataHash must be 32 bytes long");
        return byArray;
    }

    public static final class Builder {
        private PublicKeyCredentialCreationOptions zza;
        private Uri zzb;
        private byte[] zzc;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setClientDataHash(@NonNull byte[] clientDataHash) {
            void var1_1;
            BrowserPublicKeyCredentialCreationOptions.zzb(clientDataHash);
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setOrigin(@NonNull Uri origin) {
            void var1_1;
            BrowserPublicKeyCredentialCreationOptions.zza(origin);
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPublicKeyCredentialCreationOptions(@NonNull PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        @NonNull
        public BrowserPublicKeyCredentialCreationOptions build() {
            return new BrowserPublicKeyCredentialCreationOptions(this.zza, this.zzb, this.zzc);
        }
    }
}

