/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.fido.fido2.api.common.AuthenticationExtensionsClientOutputs;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorAssertionResponse;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorAttestationResponse;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorErrorResponse;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorResponse;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialType;
import com.google.android.gms.fido.fido2.api.common.zzal;
import java.util.Arrays;

@SafeParcelable.Class(creator="PublicKeyCredentialCreator")
public class PublicKeyCredential
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<PublicKeyCredential> CREATOR = new zzal();
    @NonNull
    @SafeParcelable.Field(id=1, getter="getId")
    private final String zza;
    @NonNull
    @SafeParcelable.Field(id=2, getter="getType")
    private final String zzb;
    @NonNull
    @SafeParcelable.Field(id=3, getter="getRawId")
    private final byte[] zzc;
    @Nullable
    @SafeParcelable.Field(id=4, getter="getRegisterResponse")
    private final AuthenticatorAttestationResponse zzd;
    @Nullable
    @SafeParcelable.Field(id=5, getter="getSignResponse")
    private final AuthenticatorAssertionResponse zze;
    @Nullable
    @SafeParcelable.Field(id=6, getter="getErrorResponse")
    private final AuthenticatorErrorResponse zzf;
    @Nullable
    @SafeParcelable.Field(id=7, getter="getClientExtensionResults")
    private final AuthenticationExtensionsClientOutputs zzg;
    @Nullable
    @SafeParcelable.Field(id=8, getter="getAuthenticatorAttachment")
    private final String zzh;

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzb, this.zzc, this.zze, this.zzd, this.zzf, this.zzg, this.zzh});
    }

    @Nullable
    public AuthenticationExtensionsClientOutputs getClientExtensionResults() {
        return this.zzg;
    }

    @NonNull
    public AuthenticatorResponse getResponse() {
        AuthenticatorResponse authenticatorResponse = this_.zzd;
        if (authenticatorResponse != null) {
            return authenticatorResponse;
        }
        authenticatorResponse = this_.zze;
        if (authenticatorResponse != null) {
            return authenticatorResponse;
        }
        AbstractSafeParcelable this_ = this_.zzf;
        if (this_ == null) {
            throw new IllegalStateException("No response set.");
        }
        return this_;
    }

    @NonNull
    public static PublicKeyCredential deserializeFromBytes(@NonNull byte[] serializedBytes) {
        return (PublicKeyCredential)SafeParcelableSerializer.deserializeFromBytes((byte[])serializedBytes, CREATOR);
    }

    @Nullable
    public String getAuthenticatorAttachment() {
        return this.zzh;
    }

    @NonNull
    public String getId() {
        return this.zza;
    }

    @NonNull
    public String getType() {
        return this.zzb;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    PublicKeyCredential(@NonNull @SafeParcelable.Param(id=1) String string, @NonNull @SafeParcelable.Param(id=2) String string2, @NonNull @SafeParcelable.Param(id=3) byte[] byArray, @Nullable @SafeParcelable.Param(id=4) AuthenticatorAttestationResponse authenticatorAttestationResponse, @Nullable @SafeParcelable.Param(id=5) AuthenticatorAssertionResponse authenticatorAssertionResponse, @Nullable @SafeParcelable.Param(id=6) AuthenticatorErrorResponse authenticatorErrorResponse, @Nullable @SafeParcelable.Param(id=7) AuthenticationExtensionsClientOutputs authenticationExtensionsClientOutputs, @Nullable @SafeParcelable.Param(id=8) String string3) {
        boolean bl = authenticatorAttestationResponse == null || authenticatorAssertionResponse != null || authenticatorErrorResponse != null ? (authenticatorAttestationResponse != null || authenticatorAssertionResponse == null || authenticatorErrorResponse != null ? (authenticatorAttestationResponse == null ? (authenticatorAssertionResponse == null ? authenticatorErrorResponse != null : false) : false) : true) : true;
        Preconditions.checkArgument((boolean)bl);
        this.zza = string;
        this.zzb = string2;
        this.zzc = byArray;
        this.zzd = authenticatorAttestationResponse;
        this.zze = authenticatorAssertionResponse;
        this.zzf = authenticatorErrorResponse;
        this.zzg = authenticationExtensionsClientOutputs;
        this.zzh = string3;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)1, (String)this.getId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getType(), (boolean)false);
        SafeParcelWriter.writeByteArray((Parcel)var1_1, (int)3, (byte[])this.getRawId(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)4, (Parcelable)this.zzd, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)5, (Parcelable)this.zze, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)6, (Parcelable)this.zzf, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)7, (Parcelable)this.getClientExtensionResults(), (int)var2_2, (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)8, (String)this.getAuthenticatorAttachment(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    public boolean equals(@Nullable Object obj) {
        PublicKeyCredential publicKeyCredential;
        if (!(obj instanceof PublicKeyCredential)) {
            return false;
        }
        publicKeyCredential = publicKeyCredential;
        return Objects.equal((Object)this.zza, (Object)publicKeyCredential.zza) && Objects.equal((Object)this.zzb, (Object)publicKeyCredential.zzb) && Arrays.equals(this.zzc, publicKeyCredential.zzc) && Objects.equal((Object)((Object)this.zzd), (Object)((Object)publicKeyCredential.zzd)) && Objects.equal((Object)((Object)this.zze), (Object)((Object)publicKeyCredential.zze)) && Objects.equal((Object)((Object)this.zzf), (Object)((Object)publicKeyCredential.zzf)) && Objects.equal((Object)((Object)this.zzg), (Object)((Object)publicKeyCredential.zzg)) && Objects.equal((Object)this.zzh, (Object)publicKeyCredential.zzh);
    }

    @NonNull
    public byte[] getRawId() {
        return this.zzc;
    }

    @NonNull
    public byte[] serializeToBytes() {
        return SafeParcelableSerializer.serializeToBytes((SafeParcelable)this);
    }

    public static class Builder {
        private String zza;
        private byte[] zzb;
        private AuthenticatorResponse zzc;
        private AuthenticationExtensionsClientOutputs zzd;
        private String zze;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAuthenticationExtensionsClientOutputs(@Nullable AuthenticationExtensionsClientOutputs extensionsClientOutputs) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAuthenticatorAttachment(@NonNull String authenticatorAttachment) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setId(@NonNull String id) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRawId(@NonNull byte[] rawId) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setResponse(@NonNull AuthenticatorResponse response) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public PublicKeyCredential build() {
            AuthenticatorResponse authenticatorResponse = this.zzc;
            AuthenticatorAttestationResponse authenticatorAttestationResponse = authenticatorResponse instanceof AuthenticatorAttestationResponse ? (AuthenticatorAttestationResponse)authenticatorResponse : null;
            AuthenticatorAssertionResponse authenticatorAssertionResponse = authenticatorResponse instanceof AuthenticatorAssertionResponse ? (AuthenticatorAssertionResponse)authenticatorResponse : null;
            if (authenticatorResponse instanceof AuthenticatorErrorResponse) {
                authenticatorResponse = (AuthenticatorErrorResponse)authenticatorResponse;
                return new PublicKeyCredential(this.zza, PublicKeyCredentialType.PUBLIC_KEY.toString(), this.zzb, authenticatorAttestationResponse, authenticatorAssertionResponse, (AuthenticatorErrorResponse)authenticatorResponse, this.zzd, this.zze);
            }
            authenticatorResponse = null;
            return new PublicKeyCredential(this.zza, PublicKeyCredentialType.PUBLIC_KEY.toString(), this.zzb, authenticatorAttestationResponse, authenticatorAssertionResponse, (AuthenticatorErrorResponse)authenticatorResponse, this.zzd, this.zze);
        }
    }
}

