/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fido.u2f.api.common.ErrorCode;
import com.google.android.gms.fido.u2f.api.common.ResponseData;
import com.google.android.gms.fido.u2f.api.common.zzd;
import com.google.android.gms.internal.fido.zzbi;
import com.google.android.gms.internal.fido.zzbj;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="ErrorResponseDataCreator")
public class ErrorResponseData
extends ResponseData {
    @NonNull
    public static final Parcelable.Creator<ErrorResponseData> CREATOR = new zzd();
    @VisibleForTesting
    @NonNull
    public static final String JSON_ERROR_CODE = "errorCode";
    @VisibleForTesting
    @NonNull
    public static final String JSON_ERROR_MESSAGE = "errorMessage";
    @SafeParcelable.Field(id=2, getter="getErrorCodeAsInt", type="int")
    private final ErrorCode zza;
    @SafeParcelable.Field(id=3, getter="getErrorMessage")
    private final String zzb;

    public int getErrorCodeAsInt() {
        return this.zza.getCode();
    }

    public int hashCode() {
        ErrorCode errorCode = this.zza;
        return Objects.hashCode((Object[])new Object[]{errorCode, this.zzb});
    }

    @NonNull
    public ErrorCode getErrorCode() {
        return this.zza;
    }

    @NonNull
    public String getErrorMessage() {
        return this.zzb;
    }

    @NonNull
    public String toString() {
        zzbi zzbi2 = zzbj.zza(this_);
        ErrorCode errorCode = this_.zza;
        zzbi2.zza(JSON_ERROR_CODE, errorCode.getCode());
        Object this_ = this_.zzb;
        if (this_ != null) {
            zzbi2.zzb(JSON_ERROR_MESSAGE, this_);
        }
        return zzbi2.toString();
    }

    @Override
    @NonNull
    public final JSONObject toJsonObject() {
        JSONObject jSONObject;
        block3: {
            jSONObject = new JSONObject();
            try {
                jSONObject.put(JSON_ERROR_CODE, object.zza.getCode());
                Object object = object.zzb;
                if (object == null) break block3;
            }
            catch (JSONException jSONException) {
                throw new RuntimeException(jSONException);
            }
            String string = JSON_ERROR_MESSAGE;
            jSONObject.put(string, object);
        }
        return jSONObject;
    }

    /*
     * WARNING - void declaration
     */
    public ErrorResponseData(@NonNull ErrorCode errorCode) {
        void var1_1;
        this.zza = (ErrorCode)((Object)Preconditions.checkNotNull((Object)var1_1));
        this.zzb = null;
    }

    @SafeParcelable.Constructor
    ErrorResponseData(@SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) String string) {
        this.zza = ErrorCode.toErrorCode(n);
        this.zzb = string;
    }

    /*
     * WARNING - void declaration
     */
    public ErrorResponseData(@NonNull ErrorCode errorCode, @NonNull String errorMessage) {
        void var2_2;
        void var1_1;
        this.zza = (ErrorCode)((Object)Preconditions.checkNotNull((Object)var1_1));
        this.zzb = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.getErrorCodeAsInt());
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)3, (String)this.getErrorMessage(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public boolean equals(@Nullable Object obj) {
        ErrorResponseData errorResponseData;
        if (!(obj instanceof ErrorResponseData)) {
            return false;
        }
        errorResponseData = errorResponseData;
        return Objects.equal((Object)((Object)this.zza), (Object)((Object)errorResponseData.zza)) && Objects.equal((Object)this.zzb, (Object)errorResponseData.zzb);
    }
}

