/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.fido;

import com.google.android.gms.internal.fido.zzhr;
import com.google.android.gms.internal.fido.zzht;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public final class zzhs
implements Closeable {
    private final InputStream zza;
    private zzhr zzb;
    private final byte[] zzc = new byte[8];
    private final zzht zzd = zzht.zza();

    public final long zza() throws IOException {
        objectArray.zzj((byte)-128);
        objectArray.zzi();
        long l = objectArray.zzh();
        if (l < 0L) {
            Object[] objectArray = new Object[]{Long.MAX_VALUE};
            throw new UnsupportedOperationException(String.format("the maximum supported array length is %s", objectArray));
        }
        if (l > 0L) {
            objectArray.zzd.zzg(l);
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final long zzb() throws IOException {
        long l;
        boolean bl;
        objectArray.zzd();
        if (objectArray.zzb.zzb() == 0) {
            bl = true;
        } else {
            if (objectArray.zzb.zzb() != 32) {
                Object[] objectArray = new Object[]{objectArray.zzb.zzc()};
                throw new IllegalStateException(String.format("expected major type 0 or 1 but found %s", objectArray));
            }
            bl = false;
        }
        if ((l = objectArray.zzh()) < 0L) {
            Object[] objectArray = new Object[]{Long.MAX_VALUE};
            throw new UnsupportedOperationException(String.format("the maximum supported unsigned/negative integer is %s", objectArray));
        }
        if (bl) {
            return l;
        }
        return l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public final long zzc() throws IOException {
        this.zzj((byte)-96);
        this.zzi();
        long l = this.zzh();
        if (l < 0L || l > 0x3FFFFFFFFFFFFFFFL) {
            throw new UnsupportedOperationException("the maximum supported map length is 4611686018427387903L");
        }
        if (l > 0L) {
            long l2 = l;
            this.zzd.zzg(l2 + l2);
        }
        return l;
    }

    private final long zzh() throws IOException {
        Object object;
        if (((zzhs)object).zzb.zza() < 24) {
            ((zzhs)object).zzb = null;
            return ((zzhs)object).zzb.zza();
        }
        if (((zzhs)object).zzb.zza() == 24) {
            int n = ((zzhs)object).zza.read();
            if (n == -1) {
                throw new EOFException();
            }
            ((zzhs)object).zzb = null;
            return (long)n & 0xFFL;
        }
        if (((zzhs)object).zzb.zza() == 25) {
            zzhs zzhs2 = object;
            zzhs2.zzk(zzhs2.zzc, 2);
            object = ((zzhs)object).zzc;
            long l = (long)object[1];
            return ((long)object[0] & 0xFFL) << 8 | l & 0xFFL;
        }
        if (((zzhs)object).zzb.zza() == 26) {
            zzhs zzhs3 = object;
            zzhs3.zzk(zzhs3.zzc, 4);
            object = ((zzhs)object).zzc;
            long l = (long)object[1];
            long l2 = (long)object[2];
            long l3 = (long)object[3];
            long l4 = l & 0xFFL;
            l = l2 & 0xFFL;
            return ((long)object[0] & 0xFFL) << 24 | l4 << 16 | l << 8 | l3 & 0xFFL;
        }
        if (((zzhs)object).zzb.zza() != 27) {
            Object[] objectArray = new Object[]{((zzhs)object).zzb.zza(), ((zzhs)object).zzb.zzc()};
            throw new IOException(String.format("invalid additional information %s for major type %s", objectArray));
        }
        Object object2 = object;
        super.zzk(((zzhs)object2).zzc, 8);
        object = ((zzhs)object).zzc;
        long l = (long)object[1];
        long l5 = (long)object[2];
        long l6 = (long)object[3];
        long l7 = (long)object[5];
        long l8 = (long)object[6];
        long l9 = (long)object[7];
        long l10 = ((long)object[4] & 0xFFL) << 24;
        return ((long)object[0] & 0xFFL) << 56 | (l &= 0xFFL) << 48 | (l5 &= 0xFFL) << 40 | (l6 &= 0xFFL) << 32 | l10 | (l7 &= 0xFFL) << 16 | (l8 &= 0xFFL) << 8 | l9 & 0xFFL;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final zzhr zzd() throws IOException {
        block7: {
            if (this.zzb != null) return this.zzb;
            int n = this.zza.read();
            if (n == -1) {
                this.zzd.zzb();
                return null;
            }
            this.zzb = new zzhr(n);
            switch (this.zzb.zzb()) {
                case 96: {
                    this.zzd.zze(-2L);
                    break block7;
                }
                case 64: {
                    this.zzd.zze(-1L);
                    break block7;
                }
                case -32: {
                    if (this.zzb.zza() != 31) break;
                    this.zzd.zzc();
                    return this.zzb;
                }
                default: {
                    Object[] objectArray = new Object[]{this.zzb.zzc()};
                    throw new IllegalStateException(String.format("invalid major type: %s", objectArray));
                }
                case -128: 
                case -96: 
                case -64: 
                case 0: 
                case 32: 
            }
            this.zzd.zzd();
        }
        this.zzd.zzf();
        return this.zzb;
    }

    public final String zze() throws IOException {
        this.zzj((byte)96);
        return new String(this.zzl(), StandardCharsets.UTF_8);
    }

    public zzhs(InputStream inputStream) {
        this.zza = inputStream;
    }

    private final void zzi() throws IOException {
        this.zzd();
        if (this.zzb.zza() == 31) {
            Object[] objectArray = new Object[]{this.zzb.zza()};
            throw new IllegalStateException(String.format("expected definite length but found %s", objectArray));
        }
    }

    private final void zzj(byte by) throws IOException {
        this.zzd();
        if (this.zzb.zzb() != by) {
            by = (byte)(by >> 5);
            Object[] objectArray = new Object[]{by & 7, this.zzb.zzc()};
            throw new IllegalStateException(String.format("expected major type %s but found %s", objectArray));
        }
    }

    @Override
    public final void close() throws IOException {
        this.zza.close();
        this.zzd.zzb();
    }

    private final void zzk(byte[] byArray, int n) throws IOException {
        int n2;
        for (int i = 0; i != n; i += n2) {
            int n3 = i;
            n2 = this.zza.read(byArray, n3, n - n3);
            if (n2 != -1) continue;
            throw new EOFException();
        }
        this.zzb = null;
    }

    public final boolean zzf() throws IOException {
        this.zzj((byte)-32);
        if (this.zzb.zza() > 24) {
            throw new IllegalStateException("expected simple value");
        }
        int n = (int)this.zzh();
        if (n == 20) {
            return false;
        }
        if (n != 21) {
            Object[] objectArray = new Object[]{};
            throw new IllegalStateException(String.format("expected FALSE or TRUE", objectArray));
        }
        return true;
    }

    public final byte[] zzg() throws IOException {
        this.zzj((byte)64);
        return this.zzl();
    }

    private final byte[] zzl() throws IOException {
        objectArray.zzi();
        long l = objectArray.zzh();
        if (l < 0L || l > Integer.MAX_VALUE) {
            Object[] objectArray = new Object[]{Integer.MAX_VALUE};
            throw new UnsupportedOperationException(String.format("the maximum supported byte/text string length is %s bytes", objectArray));
        }
        if ((long)objectArray.zza.available() < l) {
            throw new EOFException();
        }
        byte[] byArray = new byte[(int)l];
        super.zzk(byArray, byArray.length);
        return byArray;
    }
}

