/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorResponse;
import com.google.android.gms.fido.fido2.api.common.zzj;
import com.google.android.gms.internal.fido.zzbi;
import com.google.android.gms.internal.fido.zzbj;
import com.google.android.gms.internal.fido.zzgf;
import com.google.android.gms.internal.fido.zzgx;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="AuthenticatorAssertionResponseCreator")
public class AuthenticatorAssertionResponse
extends AuthenticatorResponse {
    @NonNull
    public static final Parcelable.Creator<AuthenticatorAssertionResponse> CREATOR = new zzj();
    @NonNull
    @SafeParcelable.Field(id=2, getter="getKeyHandle", type="byte[]")
    private final zzgx zza;
    @NonNull
    @SafeParcelable.Field(id=3, getter="getClientDataJSON", type="byte[]")
    private final zzgx zzb;
    @NonNull
    @SafeParcelable.Field(id=4, getter="getAuthenticatorData", type="byte[]")
    private final zzgx zzc;
    @NonNull
    @SafeParcelable.Field(id=5, getter="getSignature", type="byte[]")
    private final zzgx zzd;
    @Nullable
    @SafeParcelable.Field(id=6, getter="getUserHandle", type="byte[]")
    private final zzgx zze;

    public int hashCode() {
        Object[] objectArray = new Object[5];
        zzgx zzgx2 = object.zza;
        objectArray[0] = Objects.hashCode((Object[])new Object[]{zzgx2});
        zzgx2 = object.zzb;
        objectArray[1] = Objects.hashCode((Object[])new Object[]{zzgx2});
        zzgx2 = object.zzc;
        objectArray[2] = Objects.hashCode((Object[])new Object[]{zzgx2});
        zzgx2 = object.zzd;
        objectArray[3] = Objects.hashCode((Object[])new Object[]{zzgx2});
        Object object = object.zze;
        objectArray[4] = Objects.hashCode((Object[])new Object[]{object});
        return Objects.hashCode((Object[])objectArray);
    }

    @NonNull
    public static AuthenticatorAssertionResponse deserializeFromBytes(@NonNull byte[] serializedBytes) {
        return (AuthenticatorAssertionResponse)SafeParcelableSerializer.deserializeFromBytes((byte[])serializedBytes, CREATOR);
    }

    @NonNull
    public String toString() {
        zzbi zzbi2 = zzbj.zza(this_);
        byte[] byArray = this_.getKeyHandle();
        String string = zzgf.zzf().zzg(byArray, 0, byArray.length);
        zzbi2.zzb("keyHandle", string);
        byte[] byArray2 = this_.getClientDataJSON();
        string = zzgf.zzf().zzg(byArray2, 0, byArray2.length);
        zzbi2.zzb("clientDataJSON", string);
        byte[] byArray3 = this_.getAuthenticatorData();
        string = zzgf.zzf().zzg(byArray3, 0, byArray3.length);
        zzbi2.zzb("authenticatorData", string);
        byte[] byArray4 = this_.getSignature();
        string = zzgf.zzf().zzg(byArray4, 0, byArray4.length);
        zzbi2.zzb("signature", string);
        Object this_ = this_.getUserHandle();
        if (this_ != null) {
            Object object = this_;
            this_ = zzgf.zzf().zzg((byte[])object, 0, ((AuthenticatorAssertionResponse)object).length);
            zzbi2.zzb("userHandle", this_);
        }
        return zzbi2.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    AuthenticatorAssertionResponse(@NonNull @SafeParcelable.Param(id=2) byte[] object, @NonNull @SafeParcelable.Param(id=3) byte[] object2, @NonNull @SafeParcelable.Param(id=4) byte[] object3, @NonNull @SafeParcelable.Param(id=5) byte[] object4, @Nullable @SafeParcelable.Param(id=6) byte[] byArray) {
        void var1_3;
        void var5_11;
        void var4_9;
        void var3_7;
        void var2_5;
        byte[] byArray2 = (byte[])Preconditions.checkNotNull((Object)object);
        zzgx zzgx2 = zzgx.zzl(byArray2, 0, byArray2.length);
        byte[] byArray3 = (byte[])Preconditions.checkNotNull((Object)var2_5);
        zzgx zzgx3 = zzgx.zzl(byArray3, 0, byArray3.length);
        byte[] byArray4 = (byte[])Preconditions.checkNotNull((Object)var3_7);
        zzgx zzgx4 = zzgx.zzl(byArray4, 0, byArray4.length);
        byte[] byArray5 = (byte[])Preconditions.checkNotNull((Object)var4_9);
        zzgx zzgx5 = zzgx.zzl(byArray5, 0, byArray5.length);
        if (var5_11 == null) {
            Object var1_2 = null;
        } else {
            void v4 = var5_11;
            zzgx zzgx6 = zzgx.zzl((byte[])v4, 0, ((void)v4).length);
        }
        this.zza = (zzgx)Preconditions.checkNotNull((Object)zzgx2);
        this.zzb = (zzgx)Preconditions.checkNotNull((Object)zzgx3);
        this.zzc = (zzgx)Preconditions.checkNotNull((Object)zzgx4);
        this.zzd = (zzgx)Preconditions.checkNotNull((Object)zzgx5);
        this.zze = var1_3;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeByteArray((Parcel)var1_1, (int)2, (byte[])this.getKeyHandle(), (boolean)false);
        SafeParcelWriter.writeByteArray((Parcel)var1_1, (int)3, (byte[])this.getClientDataJSON(), (boolean)false);
        SafeParcelWriter.writeByteArray((Parcel)var1_1, (int)4, (byte[])this.getAuthenticatorData(), (boolean)false);
        SafeParcelWriter.writeByteArray((Parcel)var1_1, (int)5, (byte[])this.getSignature(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeByteArray((Parcel)v1, (int)6, (byte[])this.getUserHandle(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public boolean equals(@Nullable Object obj) {
        AuthenticatorAssertionResponse authenticatorAssertionResponse;
        if (!(obj instanceof AuthenticatorAssertionResponse)) {
            return false;
        }
        authenticatorAssertionResponse = authenticatorAssertionResponse;
        return Objects.equal((Object)this.zza, (Object)authenticatorAssertionResponse.zza) && Objects.equal((Object)this.zzb, (Object)authenticatorAssertionResponse.zzb) && Objects.equal((Object)this.zzc, (Object)authenticatorAssertionResponse.zzc) && Objects.equal((Object)this.zzd, (Object)authenticatorAssertionResponse.zzd) && Objects.equal((Object)this.zze, (Object)authenticatorAssertionResponse.zze);
    }

    @NonNull
    public byte[] getAuthenticatorData() {
        return this.zzc.zzm();
    }

    @Override
    @NonNull
    public byte[] getClientDataJSON() {
        return this.zzb.zzm();
    }

    @Deprecated
    @NonNull
    public byte[] getKeyHandle() {
        return this.zza.zzm();
    }

    @NonNull
    public byte[] getSignature() {
        return this.zzd.zzm();
    }

    @Nullable
    public byte[] getUserHandle() {
        zzgx this_ = ((AuthenticatorAssertionResponse)((Object)this_)).zze;
        if (this_ == null) {
            return null;
        }
        return this_.zzm();
    }

    @Override
    @NonNull
    public byte[] serializeToBytes() {
        return SafeParcelableSerializer.serializeToBytes((SafeParcelable)this);
    }

    public zzgx getAuthenticatorDataAsByteString() {
        return this.zzc;
    }

    public zzgx getClientDataJSONAsByteString() {
        return this.zzb;
    }

    @Deprecated
    public zzgx getKeyHandleAsByteString() {
        return this.zza;
    }

    public zzgx getSignatureAsByteString() {
        return this.zzd;
    }

    @Nullable
    public zzgx getUserHandleAsByteString() {
        return this.zze;
    }

    @NonNull
    public final JSONObject zza() {
        JSONObject jSONObject;
        block3: {
            try {
                jSONObject = new JSONObject();
                jSONObject.put("clientDataJSON", (Object)Base64Utils.encodeUrlSafeNoPadding((byte[])this.getClientDataJSON()));
                jSONObject.put("authenticatorData", (Object)Base64Utils.encodeUrlSafeNoPadding((byte[])this.getAuthenticatorData()));
                jSONObject.put("signature", (Object)Base64Utils.encodeUrlSafeNoPadding((byte[])this.getSignature()));
                zzgx zzgx2 = this.zze;
                if (zzgx2 == null) break block3;
            }
            catch (JSONException jSONException) {
                throw new RuntimeException("Error encoding AuthenticatorAssertionResponse to JSON object", jSONException);
            }
            jSONObject.put("userHandle", (Object)Base64Utils.encodeUrlSafeNoPadding((byte[])this.getUserHandle()));
        }
        return jSONObject;
    }
}

