/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.fido.common.Transport;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialType;
import com.google.android.gms.fido.fido2.api.common.zzap;
import com.google.android.gms.internal.fido.zzcf;
import com.google.android.gms.internal.fido.zzgx;
import com.google.android.gms.internal.fido.zzh;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="PublicKeyCredentialDescriptorCreator")
public class PublicKeyCredentialDescriptor
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<PublicKeyCredentialDescriptor> CREATOR;
    private static final zzcf zza;
    @NonNull
    @SafeParcelable.Field(id=2, getter="getTypeAsString", type="java.lang.String")
    private final PublicKeyCredentialType zzb;
    @NonNull
    @SafeParcelable.Field(id=3, getter="getId", type="byte[]")
    private final zzgx zzc;
    @Nullable
    @SafeParcelable.Field(id=4, getter="getTransports")
    private final List zzd;

    public int hashCode() {
        PublicKeyCredentialType publicKeyCredentialType = this.zzb;
        return Objects.hashCode((Object[])new Object[]{publicKeyCredentialType, this.zzc, this.zzd});
    }

    @NonNull
    public PublicKeyCredentialType getType() {
        return this.zzb;
    }

    @NonNull
    public String getTypeAsString() {
        return this.zzb.toString();
    }

    @NonNull
    public final String toString() {
        String string = String.valueOf((Object)this.zzb);
        String string2 = Base64Utils.encodeUrlSafeNoPadding((byte[])this.getId());
        String string3 = String.valueOf(this.zzd);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PublicKeyCredentialDescriptor{\n type=");
        stringBuilder.append(string);
        stringBuilder.append(", \n id=");
        stringBuilder.append(string2);
        stringBuilder.append(", \n transports=");
        stringBuilder.append(string3);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Nullable
    public List<Transport> getTransports() {
        return this.zzd;
    }

    static {
        zza = zzcf.zzm(zzh.zza, zzh.zzb);
        CREATOR = new zzap();
    }

    /*
     * WARNING - void declaration
     */
    @SafeParcelable.Constructor
    public PublicKeyCredentialDescriptor(@SafeParcelable.Param(id=2) @NonNull String type, @SafeParcelable.Param(id=3) @NonNull byte[] id, @Nullable @SafeParcelable.Param(id=4) List<Transport> transports) {
        void var3_3;
        void var1_1;
        void var2_2;
        void v0 = var2_2;
        this((String)var1_1, zzgx.zzl((byte[])v0, 0, ((void)v0).length), (List<Transport>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getTypeAsString(), (boolean)false);
        SafeParcelWriter.writeByteArray((Parcel)var1_1, (int)3, (byte[])this.getId(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeTypedList((Parcel)v1, (int)4, this.getTransports(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public boolean equals(@Nullable Object obj) {
        PublicKeyCredentialDescriptor publicKeyCredentialDescriptor;
        if (!(obj instanceof PublicKeyCredentialDescriptor)) {
            return false;
        }
        publicKeyCredentialDescriptor = publicKeyCredentialDescriptor;
        if (!this.zzb.equals((Object)publicKeyCredentialDescriptor.zzb)) {
            return false;
        }
        if (!Objects.equal((Object)this.zzc, (Object)publicKeyCredentialDescriptor.zzc)) {
            return false;
        }
        List list = this.zzd;
        if (list != null || publicKeyCredentialDescriptor.zzd != null) {
            List list2;
            if (list == null || (list2 = publicKeyCredentialDescriptor.zzd) == null) {
                return false;
            }
            return list.containsAll(list2) && publicKeyCredentialDescriptor.zzd.containsAll(this.zzd);
        }
        return true;
    }

    @NonNull
    public byte[] getId() {
        return this.zzc.zzm();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static PublicKeyCredentialDescriptor zza(@NonNull JSONObject object) throws JSONException {
        void var0_2;
        Object object2 = object;
        String string = object2.getString("type");
        byte[] byArray = Base64.decode((String)object2.getString("id"), (int)11);
        if (!object.has("transports")) return new PublicKeyCredentialDescriptor(string, byArray, (List<Transport>)var0_2);
        List<Transport> list = Transport.parseTransports(object.getJSONArray("transports"));
        return new PublicKeyCredentialDescriptor(string, byArray, (List<Transport>)var0_2);
    }

    public zzgx getIdAsByteString() {
        return this.zzc;
    }

    /*
     * WARNING - void declaration
     */
    public PublicKeyCredentialDescriptor(String type, zzgx id, @Nullable List<Transport> transports) {
        void var3_4;
        void var2_3;
        void var1_2;
        Preconditions.checkNotNull((Object)var1_2);
        try {
            this.zzb = PublicKeyCredentialType.fromString((String)var1_2);
        }
        catch (PublicKeyCredentialType.UnsupportedPublicKeyCredTypeException unsupportedPublicKeyCredTypeException) {
            throw new IllegalArgumentException(unsupportedPublicKeyCredTypeException);
        }
        this.zzc = (zzgx)Preconditions.checkNotNull((Object)var2_3);
        this.zzd = var3_4;
    }

    public static class UnsupportedPubKeyCredDescriptorException
    extends Exception {
        /*
         * WARNING - void declaration
         */
        public UnsupportedPubKeyCredDescriptorException(@NonNull String errorMessage) {
            super((String)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public UnsupportedPubKeyCredDescriptorException(@NonNull String errorMessage, @NonNull Throwable t) {
            super((String)var1_1, (Throwable)var2_2);
            void var2_2;
            void var1_1;
        }
    }
}

