/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzaz;
import com.google.android.gms.internal.zzang;
import com.google.android.gms.internal.zzaos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionInsertRequest
extends zza {
    private final int versionCode;
    private final Session zzaVY;
    private final List<DataSet> zzaVZ;
    private final List<DataPoint> zzaWa;
    private final zzaos zzaVG;
    public static final Parcelable.Creator<SessionInsertRequest> CREATOR = new zzaz();

    SessionInsertRequest(int n, Session session, List<DataSet> list, List<DataPoint> list2, IBinder iBinder) {
        this.versionCode = n;
        this.zzaVY = session;
        this.zzaVZ = Collections.unmodifiableList(list);
        this.zzaWa = Collections.unmodifiableList(list2);
        this.zzaVG = zzaos.zza.zzcJ(iBinder);
    }

    private SessionInsertRequest(Builder builder) {
        this(builder.zzaVY, builder.zzaVZ, builder.zzaWa, null);
    }

    public SessionInsertRequest(SessionInsertRequest sessionInsertRequest, zzaos zzaos2) {
        this(sessionInsertRequest.zzaVY, sessionInsertRequest.zzaVZ, sessionInsertRequest.zzaWa, zzaos2);
    }

    public SessionInsertRequest(Session session, List<DataSet> list, List<DataPoint> list2, zzaos zzaos2) {
        this.versionCode = 3;
        this.zzaVY = session;
        this.zzaVZ = Collections.unmodifiableList(list);
        this.zzaWa = Collections.unmodifiableList(list2);
        this.zzaVG = zzaos2;
    }

    public Session getSession() {
        return this.zzaVY;
    }

    public List<DataSet> getDataSets() {
        return this.zzaVZ;
    }

    public List<DataPoint> getAggregateDataPoints() {
        return this.zzaWa;
    }

    public IBinder getCallbackBinder() {
        return this.zzaVG == null ? null : this.zzaVG.asBinder();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof SessionInsertRequest && this.zzb((SessionInsertRequest)((Object)object));
    }

    private boolean zzb(SessionInsertRequest sessionInsertRequest) {
        return zzaa.equal((Object)((Object)this.zzaVY), (Object)((Object)sessionInsertRequest.zzaVY)) && zzaa.equal(this.zzaVZ, sessionInsertRequest.zzaVZ) && zzaa.equal(this.zzaWa, sessionInsertRequest.zzaWa);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaVY, this.zzaVZ, this.zzaWa});
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("session", (Object)this.zzaVY).zzg("dataSets", this.zzaVZ).zzg("aggregateDataPoints", this.zzaWa).toString();
    }

    int getVersionCode() {
        return this.versionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzaz.zza(this, parcel, n);
    }

    public static class Builder {
        private Session zzaVY;
        private List<DataSet> zzaVZ = new ArrayList<DataSet>();
        private List<DataPoint> zzaWa = new ArrayList<DataPoint>();
        private List<DataSource> zzaWb = new ArrayList<DataSource>();

        public Builder setSession(Session session) {
            this.zzaVY = session;
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            zzac.zzb((dataSet != null ? 1 : 0) != 0, (Object)"Must specify a valid data set.");
            DataSource dataSource = dataSet.getDataSource();
            zzac.zza((!this.zzaWb.contains((Object)dataSource) ? 1 : 0) != 0, (String)"Data set for this data source %s is already added.", (Object[])new Object[]{dataSource});
            List<DataPoint> list = dataSet.getDataPoints();
            zzac.zzb((!list.isEmpty() ? 1 : 0) != 0, (Object)"No data points specified in the input data set.");
            this.zzaWb.add(dataSource);
            this.zzaVZ.add(dataSet);
            return this;
        }

        public Builder addAggregateDataPoint(DataPoint dataPoint) {
            zzac.zzb((dataPoint != null ? 1 : 0) != 0, (Object)"Must specify a valid aggregate data point.");
            DataSource dataSource = dataPoint.getDataSource();
            zzac.zza((!this.zzaWb.contains((Object)dataSource) ? 1 : 0) != 0, (String)"Data set/Aggregate data point for this data source %s is already added.", (Object[])new Object[]{dataSource});
            DataSet.zze(dataPoint);
            this.zzaWb.add(dataSource);
            this.zzaWa.add(dataPoint);
            return this;
        }

        public SessionInsertRequest build() {
            zzac.zza((this.zzaVY != null ? 1 : 0) != 0, (Object)"Must specify a valid session.");
            zzac.zza((this.zzaVY.getEndTime(TimeUnit.MILLISECONDS) != 0L ? 1 : 0) != 0, (Object)"Must specify a valid end time, cannot insert a continuing session.");
            this.zzCv();
            return new SessionInsertRequest(this);
        }

        private void zzg(DataPoint dataPoint) {
            this.zzi(dataPoint);
            this.zzh(dataPoint);
        }

        private void zzh(DataPoint dataPoint) {
            long l = this.zzaVY.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = this.zzaVY.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint.getEndTime(TimeUnit.NANOSECONDS);
            if (l3 != 0L && l4 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l4 > l2) {
                    l4 = zzang.zza(l4, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzac.zza((l3 >= l && l4 <= l2 ? 1 : 0) != 0, (String)"Data point %s has start and end times outside session interval [%d, %d]", (Object[])new Object[]{dataPoint, l, l2});
                if (l4 != dataPoint.getEndTime(TimeUnit.NANOSECONDS)) {
                    Log.w((String)"Fitness", (String)String.format("Data point end time [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getEndTime(TimeUnit.NANOSECONDS), l4, timeUnit}));
                    dataPoint.setTimeInterval(l3, l4, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzi(DataPoint dataPoint) {
            long l = this.zzaVY.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = this.zzaVY.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint.getTimestamp(TimeUnit.NANOSECONDS);
            if (l3 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l3 < l || l3 > l2) {
                    l3 = zzang.zza(l3, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzac.zza((l3 >= l && l3 <= l2 ? 1 : 0) != 0, (String)"Data point %s has time stamp outside session interval [%d, %d]", (Object[])new Object[]{dataPoint, l, l2});
                if (dataPoint.getTimestamp(TimeUnit.NANOSECONDS) != l3) {
                    Log.w((String)"Fitness", (String)String.format("Data point timestamp [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getTimestamp(TimeUnit.NANOSECONDS), l3, timeUnit}));
                    dataPoint.setTimestamp(l3, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzCv() {
            for (DataSet zza2 : this.zzaVZ) {
                for (DataPoint dataPoint : zza2.getDataPoints()) {
                    this.zzg(dataPoint);
                }
            }
            for (DataPoint dataPoint : this.zzaWa) {
                this.zzg(dataPoint);
            }
        }
    }
}

