/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.annotation.TargetApi;
import android.app.AppOpsManager;
import android.app.Service;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.result.DataSourcesResult;
import com.google.android.gms.fitness.service.FitnessSensorServiceRequest;
import com.google.android.gms.internal.zzaoa;
import com.google.android.gms.internal.zzaos;
import com.google.android.gms.internal.zzapi;
import com.google.android.gms.internal.zzapk;
import com.google.android.gms.internal.zzapm;
import java.util.List;

public abstract class FitnessSensorService
extends Service {
    public static final String SERVICE_INTERFACE = "com.google.android.gms.fitness.service.FitnessSensorService";
    private zza zzaWE;

    @CallSuper
    public void onCreate() {
        super.onCreate();
        this.zzaWE = new zza(this);
    }

    @CallSuper
    public IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            if (Log.isLoggable((String)"FitnessSensorService", (int)3)) {
                String string = String.valueOf(intent);
                String string2 = String.valueOf(((Object)((Object)this)).getClass().getName());
                Log.d((String)"FitnessSensorService", (String)new StringBuilder(20 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Intent ").append(string).append(" received by ").append(string2).toString());
            }
            return this.zzaWE.asBinder();
        }
        return null;
    }

    public abstract List<DataSource> onFindDataSources(List<DataType> var1);

    public abstract boolean onRegister(FitnessSensorServiceRequest var1);

    public abstract boolean onUnregister(DataSource var1);

    @TargetApi(value=19)
    protected void zzCN() throws SecurityException {
        int n = Binder.getCallingUid();
        if (zzs.zzyF()) {
            AppOpsManager appOpsManager = (AppOpsManager)this.getSystemService("appops");
            appOpsManager.checkPackage(n, "com.google.android.gms");
            return;
        }
        PackageManager packageManager = this.getPackageManager();
        String[] stringArray = packageManager.getPackagesForUid(n);
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!string.equals("com.google.android.gms")) continue;
                return;
            }
        }
        throw new SecurityException("Unauthorized caller");
    }

    private static class zza
    extends zzapm.zza {
        private final FitnessSensorService zzaWF;

        private zza(FitnessSensorService fitnessSensorService) {
            this.zzaWF = fitnessSensorService;
        }

        @Override
        public void zza(zzapi zzapi2, zzaoa zzaoa2) throws RemoteException {
            this.zzaWF.zzCN();
            List<DataSource> list = this.zzaWF.onFindDataSources(zzapi2.getDataTypes());
            zzaoa2.zza(new DataSourcesResult(list, Status.zzayh));
        }

        @Override
        public void zza(FitnessSensorServiceRequest fitnessSensorServiceRequest, zzaos zzaos2) throws RemoteException {
            this.zzaWF.zzCN();
            if (this.zzaWF.onRegister(fitnessSensorServiceRequest)) {
                zzaos2.zzp(Status.zzayh);
            } else {
                zzaos2.zzp(new Status(13));
            }
        }

        @Override
        public void zza(zzapk zzapk2, zzaos zzaos2) throws RemoteException {
            this.zzaWF.zzCN();
            if (this.zzaWF.onUnregister(zzapk2.getDataSource())) {
                zzaos2.zzp(Status.zzayh);
            } else {
                zzaos2.zzp(new Status(13));
            }
        }
    }
}

