/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.zzaa;
import com.google.android.gms.fitness.data.zzo;
import com.google.android.gms.fitness.data.zzq;
import com.google.android.gms.fitness.data.zzr;
import com.google.android.gms.fitness.data.zzw;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Goal
extends zza {
    public static final int OBJECTIVE_TYPE_METRIC = 1;
    public static final int OBJECTIVE_TYPE_DURATION = 2;
    public static final int OBJECTIVE_TYPE_FREQUENCY = 3;
    private final int versionCode;
    private final long zzaSo;
    private final long zzaSp;
    private final List<Integer> zzaSq;
    private final Recurrence zzaSr;
    private final int zzaSs;
    private final MetricObjective zzaSt;
    private final DurationObjective zzaSu;
    private final FrequencyObjective zzaSv;
    public static final Parcelable.Creator<Goal> CREATOR = new zzr();

    public long getCreateTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaSo, TimeUnit.NANOSECONDS);
    }

    public long getStartTime(Calendar calendar, TimeUnit timeUnit) {
        if (this.zzaSr != null) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(calendar.getTime());
            switch (this.zzaSr.zzaSz) {
                case 1: {
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 2: {
                    calendar2.set(7, 2);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 3: {
                    calendar2.set(5, 1);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
            }
            int n = this.zzaSr.zzaSz;
            throw new IllegalArgumentException(new StringBuilder(24).append("Invalid unit ").append(n).toString());
        }
        return timeUnit.convert(this.zzaSo, TimeUnit.NANOSECONDS);
    }

    public long getEndTime(Calendar calendar, TimeUnit timeUnit) {
        if (this.zzaSr != null) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(calendar.getTime());
            switch (this.zzaSr.zzaSz) {
                case 1: {
                    calendar2.add(5, 1);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 2: {
                    calendar2.add(4, 1);
                    calendar2.set(7, 2);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 3: {
                    calendar2.add(2, 1);
                    calendar2.set(5, 1);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
            }
            int n = this.zzaSr.zzaSz;
            throw new IllegalArgumentException(new StringBuilder(24).append("Invalid unit ").append(n).toString());
        }
        return timeUnit.convert(this.zzaSp, TimeUnit.NANOSECONDS);
    }

    @Nullable
    public String getActivityName() {
        if (this.zzaSq.isEmpty() || this.zzaSq.size() > 1) {
            return null;
        }
        return FitnessActivities.getName(this.zzaSq.get(0));
    }

    public Recurrence getRecurrence() {
        return this.zzaSr;
    }

    public int getObjectiveType() {
        return this.zzaSs;
    }

    private static String zzgC(int n) {
        switch (n) {
            case 1: {
                return "metric";
            }
            case 2: {
                return "duration";
            }
            case 3: {
                return "frequency";
            }
            case 0: {
                return "unknown";
            }
        }
        throw new IllegalArgumentException("invalid objective type value");
    }

    public MetricObjective getMetricObjective() {
        this.zzgD(1);
        return this.zzaSt;
    }

    public DurationObjective getDurationObjective() {
        this.zzgD(2);
        return this.zzaSu;
    }

    public FrequencyObjective getFrequencyObjective() {
        this.zzgD(3);
        return this.zzaSv;
    }

    Goal(int n, long l, long l2, List<Integer> list, Recurrence recurrence, int n2, MetricObjective metricObjective, DurationObjective durationObjective, FrequencyObjective frequencyObjective) {
        this.versionCode = n;
        this.zzaSo = l;
        this.zzaSp = l2;
        this.zzaSq = list == null ? Collections.emptyList() : list;
        this.zzaSr = recurrence;
        this.zzaSs = n2;
        this.zzaSt = metricObjective;
        this.zzaSu = durationObjective;
        this.zzaSv = frequencyObjective;
    }

    int getVersionCode() {
        return this.versionCode;
    }

    public long zzBB() {
        return this.zzaSo;
    }

    public long zzBC() {
        return this.zzaSp;
    }

    public List<Integer> zzBD() {
        return this.zzaSq;
    }

    public MetricObjective zzBE() {
        return this.zzaSt;
    }

    public DurationObjective zzBF() {
        return this.zzaSu;
    }

    public FrequencyObjective zzBG() {
        return this.zzaSv;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof Goal && this.zza((Goal)((Object)object));
    }

    private boolean zza(Goal goal) {
        return this.zzaSo == goal.zzaSo && this.zzaSp == goal.zzaSp && com.google.android.gms.common.internal.zzaa.equal(this.zzaSq, goal.zzaSq) && com.google.android.gms.common.internal.zzaa.equal((Object)((Object)this.zzaSr), (Object)((Object)goal.zzaSr)) && this.zzaSs == goal.zzaSs && com.google.android.gms.common.internal.zzaa.equal((Object)((Object)this.zzaSt), (Object)((Object)goal.zzaSt)) && com.google.android.gms.common.internal.zzaa.equal((Object)((Object)this.zzaSu), (Object)((Object)goal.zzaSu)) && com.google.android.gms.common.internal.zzaa.equal((Object)((Object)this.zzaSv), (Object)((Object)goal.zzaSv));
    }

    public int hashCode() {
        return this.zzaSs;
    }

    public String toString() {
        return com.google.android.gms.common.internal.zzaa.zzv((Object)((Object)this)).zzg("activity", (Object)this.getActivityName()).zzg("recurrence", (Object)this.zzaSr).zzg("metricObjective", (Object)this.zzaSt).zzg("durationObjective", (Object)this.zzaSu).zzg("frequencyObjective", (Object)this.zzaSv).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzr.zza(this, parcel, n);
    }

    private void zzgD(int n) throws MismatchedGoalException {
        if (n != this.zzaSs) {
            throw new MismatchedGoalException(String.format("%s goal does not have %s objective", Goal.zzgC(this.zzaSs), Goal.zzgC(n)));
        }
    }

    public static class MismatchedGoalException
    extends IllegalStateException {
        public MismatchedGoalException(String string) {
            super(string);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ObjectiveType {
    }

    public static class FrequencyObjective
    extends zza {
        private final int versionCode;
        private final int frequency;
        public static final Parcelable.Creator<FrequencyObjective> CREATOR = new zzq();

        public int getFrequency() {
            return this.frequency;
        }

        FrequencyObjective(int n, int n2) {
            this.versionCode = n;
            this.frequency = n2;
        }

        public FrequencyObjective(int n) {
            this(1, n);
        }

        int getVersionCode() {
            return this.versionCode;
        }

        public boolean equals(Object object) {
            return this == object || object instanceof FrequencyObjective && this.zza((FrequencyObjective)((Object)object));
        }

        private boolean zza(FrequencyObjective frequencyObjective) {
            return this.frequency == frequencyObjective.frequency;
        }

        public int hashCode() {
            return this.frequency;
        }

        public String toString() {
            return com.google.android.gms.common.internal.zzaa.zzv((Object)((Object)this)).zzg("frequency", (Object)this.frequency).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzq.zza(this, parcel, n);
        }
    }

    public static class DurationObjective
    extends zza {
        private final int versionCode;
        private final long zzaSw;
        public static final Parcelable.Creator<DurationObjective> CREATOR = new zzo();

        public long getDuration(TimeUnit timeUnit) {
            return timeUnit.convert(this.zzaSw, TimeUnit.NANOSECONDS);
        }

        public long getDuration() {
            return this.zzaSw;
        }

        DurationObjective(int n, long l) {
            this.versionCode = n;
            this.zzaSw = l;
        }

        public DurationObjective(long l, TimeUnit timeUnit) {
            this(1, timeUnit.toNanos(l));
        }

        int getVersionCode() {
            return this.versionCode;
        }

        public boolean equals(Object object) {
            return this == object || object instanceof DurationObjective && this.zza((DurationObjective)((Object)object));
        }

        private boolean zza(DurationObjective durationObjective) {
            return this.zzaSw == durationObjective.zzaSw;
        }

        public int hashCode() {
            return (int)this.zzaSw;
        }

        public String toString() {
            return com.google.android.gms.common.internal.zzaa.zzv((Object)((Object)this)).zzg("duration", (Object)this.zzaSw).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzo.zza(this, parcel, n);
        }
    }

    public static class MetricObjective
    extends zza {
        private final int versionCode;
        private final String zzaSx;
        private final double value;
        private final double zzaSy;
        public static final Parcelable.Creator<MetricObjective> CREATOR = new zzw();

        public String getDataTypeName() {
            return this.zzaSx;
        }

        public double getValue() {
            return this.value;
        }

        public double zzBH() {
            return this.zzaSy;
        }

        MetricObjective(int n, String string, double d, double d2) {
            this.versionCode = n;
            this.zzaSx = string;
            this.value = d;
            this.zzaSy = d2;
        }

        public MetricObjective(String string, double d) {
            this(1, string, d, 0.0);
        }

        int getVersionCode() {
            return this.versionCode;
        }

        public boolean equals(Object object) {
            return this == object || object instanceof MetricObjective && this.zza((MetricObjective)((Object)object));
        }

        private boolean zza(MetricObjective metricObjective) {
            return com.google.android.gms.common.internal.zzaa.equal((Object)this.zzaSx, (Object)metricObjective.zzaSx) && this.value == metricObjective.value && this.zzaSy == metricObjective.zzaSy;
        }

        public int hashCode() {
            return this.zzaSx.hashCode();
        }

        public String toString() {
            return com.google.android.gms.common.internal.zzaa.zzv((Object)((Object)this)).zzg("dataTypeName", (Object)this.zzaSx).zzg("value", (Object)this.value).zzg("initialValue", (Object)this.zzaSy).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzw.zza(this, parcel, n);
        }
    }

    public static class Recurrence
    extends zza {
        public static final int UNIT_DAY = 1;
        public static final int UNIT_WEEK = 2;
        public static final int UNIT_MONTH = 3;
        private final int versionCode;
        private final int count;
        private final int zzaSz;
        public static final Parcelable.Creator<Recurrence> CREATOR = new zzaa();

        public int getCount() {
            return this.count;
        }

        public int getUnit() {
            return this.zzaSz;
        }

        private static String zzgE(int n) {
            switch (n) {
                case 1: {
                    return "day";
                }
                case 2: {
                    return "week";
                }
                case 3: {
                    return "month";
                }
            }
            throw new IllegalArgumentException("invalid unit value");
        }

        Recurrence(int n, int n2, int n3) {
            this.versionCode = n;
            this.count = n2;
            zzac.zzar((n3 > 0 && n3 <= 3 ? 1 : 0) != 0);
            this.zzaSz = n3;
        }

        public Recurrence(int n, int n2) {
            this(1, n, n2);
        }

        int getVersionCode() {
            return this.versionCode;
        }

        public boolean equals(Object object) {
            return this == object || object instanceof Recurrence && this.zza((Recurrence)((Object)object));
        }

        private boolean zza(Recurrence recurrence) {
            return this.count == recurrence.count && this.zzaSz == recurrence.zzaSz;
        }

        public int hashCode() {
            return this.zzaSz;
        }

        public String toString() {
            return com.google.android.gms.common.internal.zzaa.zzv((Object)((Object)this)).zzg("count", (Object)this.count).zzg("unit", (Object)Recurrence.zzgE(this.zzaSz)).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzaa.zza(this, parcel, n);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RecurrenceUnit {
        }
    }
}

