/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzf;
import com.google.android.gms.internal.zzaos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
extends zza {
    private final int mVersionCode;
    private final long zzaed;
    private final long zzaQV;
    private final List<DataSource> zzaUV;
    private final List<DataType> zzaQU;
    private final List<Session> zzaUW;
    private final boolean zzaUX;
    private final boolean zzaUY;
    private final zzaos zzaUS;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new zzf();

    DataDeleteRequest(int n, long l, long l2, List<DataSource> list, List<DataType> list2, List<Session> list3, boolean bl, boolean bl2, IBinder iBinder) {
        this.mVersionCode = n;
        this.zzaed = l;
        this.zzaQV = l2;
        this.zzaUV = Collections.unmodifiableList(list);
        this.zzaQU = Collections.unmodifiableList(list2);
        this.zzaUW = list3;
        this.zzaUX = bl;
        this.zzaUY = bl2;
        this.zzaUS = zzaos.zza.zzcJ(iBinder);
    }

    private DataDeleteRequest(Builder builder) {
        this(builder.zzaed, builder.zzaQV, builder.zzaUV, builder.zzaQU, builder.zzaUW, builder.zzaUX, builder.zzaUY, null);
    }

    public DataDeleteRequest(DataDeleteRequest dataDeleteRequest, zzaos zzaos2) {
        this(dataDeleteRequest.zzaed, dataDeleteRequest.zzaQV, dataDeleteRequest.zzaUV, dataDeleteRequest.zzaQU, dataDeleteRequest.zzaUW, dataDeleteRequest.zzaUX, dataDeleteRequest.zzaUY, zzaos2);
    }

    public DataDeleteRequest(long l, long l2, List<DataSource> list, List<DataType> list2, List<Session> list3, boolean bl, boolean bl2, zzaos zzaos2) {
        this.mVersionCode = 3;
        this.zzaed = l;
        this.zzaQV = l2;
        this.zzaUV = Collections.unmodifiableList(list);
        this.zzaQU = Collections.unmodifiableList(list2);
        this.zzaUW = list3;
        this.zzaUX = bl;
        this.zzaUY = bl2;
        this.zzaUS = zzaos2;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaed, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaQV, TimeUnit.MILLISECONDS);
    }

    public List<DataSource> getDataSources() {
        return this.zzaUV;
    }

    public List<DataType> getDataTypes() {
        return this.zzaQU;
    }

    public List<Session> getSessions() {
        return this.zzaUW;
    }

    public boolean deleteAllData() {
        return this.zzaUX;
    }

    public boolean deleteAllSessions() {
        return this.zzaUY;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof DataDeleteRequest && this.zzb((DataDeleteRequest)((Object)object));
    }

    private boolean zzb(DataDeleteRequest dataDeleteRequest) {
        return this.zzaed == dataDeleteRequest.zzaed && this.zzaQV == dataDeleteRequest.zzaQV && zzaa.equal(this.zzaUV, dataDeleteRequest.zzaUV) && zzaa.equal(this.zzaQU, dataDeleteRequest.zzaQU) && zzaa.equal(this.zzaUW, dataDeleteRequest.zzaUW) && this.zzaUX == dataDeleteRequest.zzaUX && this.zzaUY == dataDeleteRequest.zzaUY;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaed, this.zzaQV});
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("startTimeMillis", (Object)this.zzaed).zzg("endTimeMillis", (Object)this.zzaQV).zzg("dataSources", this.zzaUV).zzg("dateTypes", this.zzaQU).zzg("sessions", this.zzaUW).zzg("deleteAllData", (Object)this.zzaUX).zzg("deleteAllSessions", (Object)this.zzaUY).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean zzBZ() {
        return this.zzaUX;
    }

    public boolean zzCa() {
        return this.zzaUY;
    }

    public long zzzx() {
        return this.zzaQV;
    }

    public long zzpN() {
        return this.zzaed;
    }

    public IBinder getCallbackBinder() {
        return this.zzaUS == null ? null : this.zzaUS.asBinder();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzf.zza(this, parcel, n);
    }

    public static class Builder {
        private long zzaed;
        private long zzaQV;
        private List<DataSource> zzaUV = new ArrayList<DataSource>();
        private List<DataType> zzaQU = new ArrayList<DataType>();
        private List<Session> zzaUW = new ArrayList<Session>();
        private boolean zzaUX = false;
        private boolean zzaUY = false;

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            zzac.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{l});
            zzac.zzb((l2 > l ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{l2});
            this.zzaed = timeUnit.toMillis(l);
            this.zzaQV = timeUnit.toMillis(l2);
            return this;
        }

        public Builder deleteAllData() {
            zzac.zzb((boolean)this.zzaQU.isEmpty(), (Object)"Specific data type already added for deletion. deleteAllData() will delete all data types and cannot be combined with addDataType()");
            zzac.zzb((boolean)this.zzaUV.isEmpty(), (Object)"Specific data source already added for deletion. deleteAllData() will delete all data sources and cannot be combined with addDataSource()");
            this.zzaUX = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            zzac.zzb((!this.zzaUX ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataType() cannot be combined with deleteAllData()");
            zzac.zzb((dataType != null ? 1 : 0) != 0, (Object)"Must specify a valid data type");
            if (!this.zzaQU.contains((Object)dataType)) {
                this.zzaQU.add(dataType);
            }
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            zzac.zzb((!this.zzaUX ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataSource() cannot be combined with deleteAllData()");
            zzac.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Must specify a valid data source");
            if (!this.zzaUV.contains((Object)dataSource)) {
                this.zzaUV.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            zzac.zzb((!this.zzaUY ? 1 : 0) != 0, (Object)"All sessions already marked for deletion.  addSession() cannot be combined with deleteAllSessions()");
            zzac.zzb((session != null ? 1 : 0) != 0, (Object)"Must specify a valid session");
            zzac.zzb((session.getEndTime(TimeUnit.MILLISECONDS) > 0L ? 1 : 0) != 0, (Object)"Cannot delete an ongoing session. Please stop the session prior to deleting it");
            this.zzaUW.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            zzac.zzb((boolean)this.zzaUW.isEmpty(), (Object)"Specific session already added for deletion. deleteAllData() will delete all sessions and cannot be combined with addSession()");
            this.zzaUY = true;
            return this;
        }

        public DataDeleteRequest build() {
            zzac.zza((this.zzaed > 0L && this.zzaQV > this.zzaed ? 1 : 0) != 0, (Object)"Must specify a valid time interval");
            boolean bl = this.zzaUX || !this.zzaUV.isEmpty() || !this.zzaQU.isEmpty();
            boolean bl2 = this.zzaUY || !this.zzaUW.isEmpty();
            zzac.zza((bl || bl2 ? 1 : 0) != 0, (Object)"No data or session marked for deletion");
            this.zzCb();
            return new DataDeleteRequest(this);
        }

        private void zzCb() {
            if (this.zzaUW.isEmpty()) {
                return;
            }
            for (Session session : this.zzaUW) {
                zzac.zza((session.getStartTime(TimeUnit.MILLISECONDS) >= this.zzaed && session.getEndTime(TimeUnit.MILLISECONDS) <= this.zzaQV ? 1 : 0) != 0, (String)"Session %s is outside the time interval [%d, %d]", (Object[])new Object[]{session, this.zzaed, this.zzaQV});
            }
        }
    }
}

