/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzb;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.BleScanCallback;
import com.google.android.gms.fitness.request.zza;
import com.google.android.gms.fitness.request.zzai;
import com.google.android.gms.fitness.request.zzbj;
import com.google.android.gms.internal.zzaos;
import java.util.Collections;
import java.util.List;

public class StartBleScanRequest
extends zza {
    private final int mVersionCode;
    private final List<DataType> zzaQU;
    private final zzai zzaWi;
    private final int zzaWj;
    private final zzaos zzaUS;
    public static final Parcelable.Creator<StartBleScanRequest> CREATOR = new zzbj();

    StartBleScanRequest(int n, List<DataType> list, IBinder iBinder, int n2, IBinder iBinder2) {
        this.mVersionCode = n;
        this.zzaQU = list;
        this.zzaWi = zzai.zza.zzcN(iBinder);
        this.zzaWj = n2;
        this.zzaUS = zzaos.zza.zzcJ(iBinder2);
    }

    private StartBleScanRequest(Builder builder) {
        this(zzb.zzb((Object[])builder.zzaVp), builder.zzaWi, builder.zzaWj, null);
    }

    public StartBleScanRequest(StartBleScanRequest startBleScanRequest, zzaos zzaos2) {
        this(startBleScanRequest.zzaQU, startBleScanRequest.zzaWi, startBleScanRequest.zzaWj, zzaos2);
    }

    public StartBleScanRequest(List<DataType> list, zzai zzai2, int n, zzaos zzaos2) {
        this.mVersionCode = 4;
        this.zzaQU = list;
        this.zzaWi = zzai2;
        this.zzaWj = n;
        this.zzaUS = zzaos2;
    }

    public List<DataType> getDataTypes() {
        return Collections.unmodifiableList(this.zzaQU);
    }

    public int getTimeoutSecs() {
        return this.zzaWj;
    }

    public IBinder zzCy() {
        return this.zzaWi.asBinder();
    }

    public IBinder getCallbackBinder() {
        return this.zzaUS == null ? null : this.zzaUS.asBinder();
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("dataTypes", this.zzaQU).zzg("timeoutSecs", (Object)this.zzaWj).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzbj.zza(this, parcel, n);
    }

    public static class Builder {
        private DataType[] zzaVp = new DataType[0];
        private zzai zzaWi;
        private int zzaWj = 10;

        public Builder setDataTypes(DataType ... dataTypeArray) {
            this.zzaVp = dataTypeArray;
            return this;
        }

        public Builder setBleScanCallback(BleScanCallback bleScanCallback) {
            this.zza(zza.zza.zzBW().zza(bleScanCallback));
            return this;
        }

        public Builder zza(zzai zzai2) {
            this.zzaWi = zzai2;
            return this;
        }

        public Builder setTimeoutSecs(int n) {
            zzac.zzb((n > 0 ? 1 : 0) != 0, (Object)"Stop time must be greater than zero");
            zzac.zzb((n <= 60 ? 1 : 0) != 0, (Object)"Stop time must be less than 1 minute");
            this.zzaWj = n;
            return this;
        }

        public StartBleScanRequest build() {
            zzac.zza((this.zzaWi != null ? 1 : 0) != 0, (Object)"Must set BleScanCallback");
            return new StartBleScanRequest(this);
        }
    }
}

