/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.result.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataReadResult
extends zza
implements Result {
    private final int mVersionCode;
    private final List<DataSet> zzaQX;
    private final Status zzahq;
    private final List<Bucket> zzaWo;
    private int zzaWp;
    private final List<DataSource> zzaWq;
    private final List<DataType> zzaWr;
    public static final Parcelable.Creator<DataReadResult> CREATOR = new zzc();

    DataReadResult(int n, List<RawDataSet> list, Status status, List<RawBucket> list2, int n2, List<DataSource> list3, List<DataType> list4) {
        this.mVersionCode = n;
        this.zzahq = status;
        this.zzaWp = n2;
        this.zzaWq = list3;
        this.zzaWr = list4;
        this.zzaQX = new ArrayList<DataSet>(list.size());
        for (RawDataSet zza2 : list) {
            this.zzaQX.add(new DataSet(zza2, list3));
        }
        this.zzaWo = new ArrayList<Bucket>(list2.size());
        for (RawBucket rawBucket : list2) {
            this.zzaWo.add(new Bucket(rawBucket, list3));
        }
    }

    public DataReadResult(List<DataSet> list, List<Bucket> list2, Status status) {
        this.mVersionCode = 5;
        this.zzaQX = list;
        this.zzahq = status;
        this.zzaWo = list2;
        this.zzaWp = 1;
        this.zzaWq = new ArrayList<DataSource>();
        this.zzaWr = new ArrayList<DataType>();
    }

    public static DataReadResult zza(Status status, List<DataType> list, List<DataSource> list2) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataSource zza2 : list2) {
            arrayList.add(DataSet.create(zza2));
        }
        for (DataType dataType : list) {
            DataSource dataSource = new DataSource.Builder().setDataType(dataType).setType(1).setName("Default").build();
            arrayList.add(DataSet.create(dataSource));
        }
        return new DataReadResult(arrayList, Collections.emptyList(), status);
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzaQX) {
            if (!dataType.equals((Object)dataSet.getDataType())) continue;
            return dataSet;
        }
        return DataSet.create(new DataSource.Builder().setDataType(dataType).setType(1).build());
    }

    public DataSet getDataSet(DataSource dataSource) {
        for (DataSet dataSet : this.zzaQX) {
            if (!dataSource.equals((Object)dataSet.getDataSource())) continue;
            return dataSet;
        }
        return DataSet.create(dataSource);
    }

    public List<DataSet> getDataSets() {
        return this.zzaQX;
    }

    public List<Bucket> getBuckets() {
        return this.zzaWo;
    }

    public int zzCC() {
        return this.zzaWp;
    }

    public void zzb(DataReadResult dataReadResult) {
        for (DataSet zza2 : dataReadResult.getDataSets()) {
            this.zza(zza2, this.zzaQX);
        }
        for (Bucket bucket : dataReadResult.getBuckets()) {
            this.zza(bucket, this.zzaWo);
        }
    }

    private void zza(DataSet dataSet, List<DataSet> list) {
        for (DataSet dataSet2 : list) {
            if (!dataSet2.getDataSource().equals((Object)dataSet.getDataSource())) continue;
            dataSet2.zzb(dataSet.getDataPoints());
            return;
        }
        list.add(dataSet);
    }

    private void zza(Bucket bucket, List<Bucket> list) {
        for (Bucket bucket2 : list) {
            if (!bucket2.zzb(bucket)) continue;
            for (DataSet dataSet : bucket.getDataSets()) {
                this.zza(dataSet, bucket2.getDataSets());
            }
            return;
        }
        this.zzaWo.add(bucket);
    }

    public Status getStatus() {
        return this.zzahq;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DataReadResult && this.zzc((DataReadResult)((Object)object));
    }

    private boolean zzc(DataReadResult dataReadResult) {
        return this.zzahq.equals((Object)dataReadResult.zzahq) && zzaa.equal(this.zzaQX, dataReadResult.zzaQX) && zzaa.equal(this.zzaWo, dataReadResult.zzaWo);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzahq, this.zzaQX, this.zzaWo});
    }

    public String toString() {
        Object object;
        Object object2;
        int n;
        zzaa.zza zza2 = zzaa.zzv((Object)((Object)this)).zzg("status", (Object)this.zzahq);
        if (this.zzaQX.size() > 5) {
            n = this.zzaQX.size();
            object2 = new StringBuilder(21).append(n).append(" data sets").toString();
        } else {
            object2 = this.zzaQX;
        }
        zzaa.zza zza3 = zza2.zzg("dataSets", object2);
        if (this.zzaWo.size() > 5) {
            n = this.zzaWo.size();
            object = new StringBuilder(19).append(n).append(" buckets").toString();
        } else {
            object = this.zzaWo;
        }
        return zza3.zzg("buckets", object).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    List<RawBucket> zzCD() {
        ArrayList<RawBucket> arrayList = new ArrayList<RawBucket>(this.zzaWo.size());
        for (Bucket bucket : this.zzaWo) {
            arrayList.add(new RawBucket(bucket, this.zzaWq, this.zzaWr));
        }
        return arrayList;
    }

    List<RawDataSet> zzCE() {
        ArrayList<RawDataSet> arrayList = new ArrayList<RawDataSet>(this.zzaQX.size());
        for (DataSet dataSet : this.zzaQX) {
            arrayList.add(new RawDataSet(dataSet, this.zzaWq, this.zzaWr));
        }
        return arrayList;
    }

    List<DataSource> zzBr() {
        return this.zzaWq;
    }

    List<DataType> zzCF() {
        return this.zzaWr;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }
}

