/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.zzb;
import com.google.android.gms.fitness.data.zzz;
import com.google.android.gms.fitness.zza;
import java.util.concurrent.TimeUnit;

public class Session
extends com.google.android.gms.common.internal.safeparcel.zza {
    public static final String EXTRA_SESSION = "vnd.google.fitness.session";
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.session/";
    private final int zzaiI;
    private final long zzafe;
    private final long zzaSt;
    private final String mName;
    private final String zzaUk;
    private final String zzade;
    private final int zzaSu;
    private final zzb zzaUl;
    private final Long zzaUm;
    public static final Parcelable.Creator<Session> CREATOR = new zzz();

    Session(int n, long l, long l2, String string, String string2, String string3, int n2, zzb zzb2, Long l3) {
        this.zzaiI = n;
        this.zzafe = l;
        this.zzaSt = l2;
        this.mName = string;
        this.zzaUk = string2;
        this.zzade = string3;
        this.zzaSu = n2;
        this.zzaUl = zzb2;
        this.zzaUm = l3;
    }

    public Session(long l, long l2, String string, String string2, String string3, int n, zzb zzb2, Long l3) {
        this(3, l, l2, string, string2, string3, n, zzb2, l3);
    }

    private Session(Builder builder) {
        this(builder.zzafe, builder.zzaSt, builder.mName, builder.zzaUk, builder.zzade, builder.zzaSu, null, builder.zzaUm);
    }

    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Session)zzd.zza((Intent)intent, (String)EXTRA_SESSION, CREATOR);
    }

    public static String getMimeType(String string) {
        String string2 = String.valueOf(MIME_TYPE_PREFIX);
        String string3 = String.valueOf(string);
        return string3.length() != 0 ? string2.concat(string3) : new String(string2);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzafe, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaSt, TimeUnit.MILLISECONDS);
    }

    public long getActiveTime(TimeUnit timeUnit) {
        zzac.zza((this.zzaUm != null ? 1 : 0) != 0, (Object)"Active time is not set");
        return timeUnit.convert(this.zzaUm, TimeUnit.MILLISECONDS);
    }

    public boolean hasActiveTime() {
        return this.zzaUm != null;
    }

    public boolean isOngoing() {
        return this.zzaSt == 0L;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.zzaUk;
    }

    public String getDescription() {
        return this.zzade;
    }

    public String getActivity() {
        return zza.getName(this.zzaSu);
    }

    public int zzBW() {
        return this.zzaSu;
    }

    public zzb zzCi() {
        return this.zzaUl;
    }

    public String getAppPackageName() {
        return this.zzaUl == null ? null : this.zzaUl.getPackageName();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Session && this.zza((Session)((Object)object));
    }

    private boolean zza(Session session) {
        return this.zzafe == session.zzafe && this.zzaSt == session.zzaSt && zzaa.equal((Object)this.mName, (Object)session.mName) && zzaa.equal((Object)this.zzaUk, (Object)session.zzaUk) && zzaa.equal((Object)this.zzade, (Object)session.zzade) && zzaa.equal((Object)((Object)this.zzaUl), (Object)((Object)session.zzaUl)) && this.zzaSu == session.zzaSu;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzafe, this.zzaSt, this.zzaUk});
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("startTime", (Object)this.zzafe).zzg("endTime", (Object)this.zzaSt).zzg("name", (Object)this.mName).zzg("identifier", (Object)this.zzaUk).zzg("description", (Object)this.zzade).zzg("activity", (Object)this.zzaSu).zzg("application", (Object)this.zzaUl).toString();
    }

    int getVersionCode() {
        return this.zzaiI;
    }

    public long zzqn() {
        return this.zzafe;
    }

    public long zzAm() {
        return this.zzaSt;
    }

    public Long zzCy() {
        return this.zzaUm;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzz.zza(this, parcel, n);
    }

    public static class Builder {
        private long zzafe = 0L;
        private long zzaSt = 0L;
        private String mName = null;
        private String zzaUk;
        private String zzade;
        private int zzaSu = 4;
        private Long zzaUm;

        public Builder setStartTime(long l, TimeUnit timeUnit) {
            zzac.zza((l > 0L ? 1 : 0) != 0, (Object)"Start time should be positive.");
            this.zzafe = timeUnit.toMillis(l);
            return this;
        }

        public Builder setEndTime(long l, TimeUnit timeUnit) {
            zzac.zza((l >= 0L ? 1 : 0) != 0, (Object)"End time should be positive.");
            this.zzaSt = timeUnit.toMillis(l);
            return this;
        }

        public Builder setName(String string) {
            zzac.zzb((string.length() <= 100 ? 1 : 0) != 0, (String)"Session name cannot exceed %d characters", (Object[])new Object[]{100});
            this.mName = string;
            return this;
        }

        public Builder setIdentifier(String string) {
            zzac.zzax((string != null && TextUtils.getTrimmedLength((CharSequence)string) > 0 ? 1 : 0) != 0);
            this.zzaUk = string;
            return this;
        }

        public Builder setDescription(String string) {
            zzac.zzb((string.length() <= 1000 ? 1 : 0) != 0, (String)"Session description cannot exceed %d characters", (Object[])new Object[]{1000});
            this.zzade = string;
            return this;
        }

        public Builder setActivity(String string) {
            return this.zzgV(zza.zzdU(string));
        }

        public Builder zzgV(int n) {
            this.zzaSu = n;
            return this;
        }

        public Builder setActiveTime(long l, TimeUnit timeUnit) {
            this.zzaUm = timeUnit.toMillis(l);
            return this;
        }

        public Session build() {
            zzac.zza((this.zzafe > 0L ? 1 : 0) != 0, (Object)"Start time should be specified.");
            zzac.zza((this.zzaSt == 0L || this.zzaSt > this.zzafe ? 1 : 0) != 0, (Object)"End time should be later than start time.");
            if (this.zzaUk == null) {
                String string = this.mName == null ? "" : this.mName;
                long l = this.zzafe;
                this.zzaUk = new StringBuilder(20 + String.valueOf(string).length()).append(string).append(l).toString();
            }
            if (this.zzade == null) {
                this.zzade = "";
            }
            return new Session(this);
        }
    }
}

