/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.request.zzs;
import com.google.android.gms.internal.zzapf;
import java.util.concurrent.TimeUnit;

public class DataUpdateRequest
extends zza {
    private final int zzaiI;
    private final long zzafe;
    private final long zzaSt;
    private final DataSet zzaUn;
    private final zzapf zzaVt;
    public static final Parcelable.Creator<DataUpdateRequest> CREATOR = new zzs();

    DataUpdateRequest(int n, long l, long l2, DataSet dataSet, IBinder iBinder) {
        this.zzaiI = n;
        this.zzafe = l;
        this.zzaSt = l2;
        this.zzaUn = dataSet;
        this.zzaVt = zzapf.zza.zzcJ(iBinder);
    }

    private DataUpdateRequest(Builder builder) {
        this(builder.zzafe, builder.zzaSt, builder.zzaUn, null);
    }

    public DataUpdateRequest(long l, long l2, DataSet dataSet, IBinder iBinder) {
        this.zzaiI = 1;
        this.zzafe = l;
        this.zzaSt = l2;
        this.zzaUn = dataSet;
        this.zzaVt = zzapf.zza.zzcJ(iBinder);
    }

    public DataUpdateRequest(DataUpdateRequest dataUpdateRequest, IBinder iBinder) {
        this(dataUpdateRequest.zzqn(), dataUpdateRequest.zzAm(), dataUpdateRequest.getDataSet(), iBinder);
    }

    public long zzqn() {
        return this.zzafe;
    }

    public long zzAm() {
        return this.zzaSt;
    }

    public DataSet getDataSet() {
        return this.zzaUn;
    }

    public IBinder getCallbackBinder() {
        return this.zzaVt == null ? null : this.zzaVt.asBinder();
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzafe, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaSt, TimeUnit.MILLISECONDS);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof DataUpdateRequest && this.zzb((DataUpdateRequest)((Object)object));
    }

    private boolean zzb(DataUpdateRequest dataUpdateRequest) {
        return this.zzafe == dataUpdateRequest.zzafe && this.zzaSt == dataUpdateRequest.zzaSt && zzaa.equal((Object)((Object)this.zzaUn), (Object)((Object)dataUpdateRequest.zzaUn));
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzafe, this.zzaSt, this.zzaUn});
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("startTimeMillis", (Object)this.zzafe).zzg("endTimeMillis", (Object)this.zzaSt).zzg("dataSet", (Object)this.zzaUn).toString();
    }

    int getVersionCode() {
        return this.zzaiI;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzs.zza(this, parcel, n);
    }

    public static class Builder {
        private long zzafe;
        private long zzaSt;
        private DataSet zzaUn;

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            zzac.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{l});
            zzac.zzb((l2 >= l ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{l2});
            this.zzafe = timeUnit.toMillis(l);
            this.zzaSt = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setDataSet(DataSet dataSet) {
            zzac.zzb((Object)((Object)dataSet), (Object)"Must set the data set");
            this.zzaUn = dataSet;
            return this;
        }

        public DataUpdateRequest build() {
            this.zzCY();
            return new DataUpdateRequest(this);
        }

        private void zzCY() {
            zzac.zza((long)this.zzafe, (Object)"Must set a non-zero value for startTimeMillis/startTime");
            zzac.zza((long)this.zzaSt, (Object)"Must set a non-zero value for endTimeMillis/endTime");
            zzac.zzb((Object)((Object)this.zzaUn), (Object)"Must set the data set");
            for (DataPoint dataPoint : this.zzaUn.getDataPoints()) {
                long l;
                long l2 = dataPoint.getStartTime(TimeUnit.MILLISECONDS);
                boolean bl = l2 > (l = dataPoint.getEndTime(TimeUnit.MILLISECONDS)) || l2 != 0L && l2 < this.zzafe || l2 != 0L && l2 > this.zzaSt || l > this.zzaSt || l < this.zzafe;
                zzac.zza((!bl ? 1 : 0) != 0, (String)"Data Point's startTimeMillis %d, endTimeMillis %d should lie between timeRange provided in the request. StartTimeMillis %d, EndTimeMillis: %d", (Object[])new Object[]{l2, l, this.zzafe, this.zzaSt});
            }
        }
    }
}

