/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Subscription;
import com.google.android.gms.fitness.result.zzo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListSubscriptionsResult
extends zza
implements Result {
    private final int zzaiI;
    private final List<Subscription> zzaXb;
    private final Status zzair;
    public static final Parcelable.Creator<ListSubscriptionsResult> CREATOR = new zzo();

    ListSubscriptionsResult(int n, List<Subscription> list, Status status) {
        this.zzaiI = n;
        this.zzaXb = list;
        this.zzair = status;
    }

    public ListSubscriptionsResult(List<Subscription> list, Status status) {
        this.zzaiI = 3;
        this.zzaXb = Collections.unmodifiableList(list);
        this.zzair = (Status)zzac.zzb((Object)status, (Object)"status");
    }

    public static ListSubscriptionsResult zzah(Status status) {
        return new ListSubscriptionsResult(Collections.emptyList(), status);
    }

    public List<Subscription> getSubscriptions() {
        return this.zzaXb;
    }

    public List<Subscription> getSubscriptions(DataType dataType) {
        ArrayList<Subscription> arrayList = new ArrayList<Subscription>();
        for (Subscription subscription : this.zzaXb) {
            if (!dataType.equals((Object)subscription.zzCA())) continue;
            arrayList.add(subscription);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Status getStatus() {
        return this.zzair;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof ListSubscriptionsResult && this.zzb((ListSubscriptionsResult)((Object)object));
    }

    private boolean zzb(ListSubscriptionsResult listSubscriptionsResult) {
        return this.zzair.equals((Object)listSubscriptionsResult.zzair) && zzaa.equal(this.zzaXb, listSubscriptionsResult.zzaXb);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzair, this.zzaXb});
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("status", (Object)this.zzair).zzg("subscriptions", this.zzaXb).toString();
    }

    int getVersionCode() {
        return this.zzaiI;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzo.zza(this, parcel, n);
    }
}

