/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.data.zzb;
import com.google.android.gms.fitness.data.zzj;

public class DataSource
extends zza {
    private static final int[] zzaSJ = new int[0];
    public static final String EXTRA_DATA_SOURCE = "vnd.google.fitness.data_source";
    public static final int TYPE_RAW = 0;
    public static final int TYPE_DERIVED = 1;
    public static final int DATA_QUALITY_BLOOD_PRESSURE_ESH2002 = 1;
    public static final int DATA_QUALITY_BLOOD_PRESSURE_ESH2010 = 2;
    public static final int DATA_QUALITY_BLOOD_PRESSURE_AAMI = 3;
    public static final int DATA_QUALITY_BLOOD_PRESSURE_BHS_A_A = 4;
    public static final int DATA_QUALITY_BLOOD_PRESSURE_BHS_A_B = 5;
    public static final int DATA_QUALITY_BLOOD_PRESSURE_BHS_B_A = 6;
    public static final int DATA_QUALITY_BLOOD_PRESSURE_BHS_B_B = 7;
    public static final int DATA_QUALITY_BLOOD_GLUCOSE_ISO151972003 = 8;
    public static final int DATA_QUALITY_BLOOD_GLUCOSE_ISO151972013 = 9;
    private final int versionCode;
    private final DataType zzaSg;
    private final String name;
    private final int type;
    private final Device zzaSK;
    private final zzb zzaSL;
    private final String zzaSM;
    private final int[] zzaSN;
    private final String zzaSO;
    public static final Parcelable.Creator<DataSource> CREATOR = new zzj();

    DataSource(int n, DataType dataType, String string, int n2, Device device, zzb zzb2, String string2, int[] nArray) {
        this.versionCode = n;
        this.zzaSg = dataType;
        this.type = n2;
        this.name = string;
        this.zzaSK = device;
        this.zzaSL = zzb2;
        this.zzaSM = string2;
        this.zzaSO = this.zzCj();
        this.zzaSN = nArray != null ? nArray : zzaSJ;
    }

    private DataSource(Builder builder) {
        this.versionCode = 3;
        this.zzaSg = builder.zzaSg;
        this.type = builder.type;
        this.name = builder.name;
        this.zzaSK = builder.zzaSK;
        this.zzaSL = builder.zzaSL;
        this.zzaSM = builder.zzaSM;
        this.zzaSO = this.zzCj();
        this.zzaSN = builder.zzaSN;
    }

    public static DataSource extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataSource)zzd.zza((Intent)intent, (String)EXTRA_DATA_SOURCE, CREATOR);
    }

    public DataType getDataType() {
        return this.zzaSg;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getAppPackageName() {
        return this.zzaSL == null ? null : this.zzaSL.getPackageName();
    }

    public zzb zzCi() {
        return this.zzaSL;
    }

    public Device getDevice() {
        return this.zzaSK;
    }

    public String getStreamName() {
        return this.zzaSM;
    }

    public int[] getDataQualityStandards() {
        return this.zzaSN;
    }

    public String getStreamIdentifier() {
        return this.zzaSO;
    }

    private String zzCj() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTypeString());
        stringBuilder.append(":").append(this.zzaSg.getName());
        if (this.zzaSL != null) {
            stringBuilder.append(":").append(this.zzaSL.getPackageName());
        }
        if (this.zzaSK != null) {
            stringBuilder.append(":").append(this.zzaSK.getStreamIdentifier());
        }
        if (this.zzaSM != null) {
            stringBuilder.append(":").append(this.zzaSM);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DataSource && this.zza((DataSource)((Object)object));
    }

    private boolean zza(DataSource dataSource) {
        return this.zzaSO.equals(dataSource.zzaSO);
    }

    public int hashCode() {
        return this.zzaSO.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DataSource{");
        stringBuilder.append(this.getTypeString());
        if (this.name != null) {
            stringBuilder.append(":").append(this.name);
        }
        if (this.zzaSL != null) {
            stringBuilder.append(":").append((Object)this.zzaSL);
        }
        if (this.zzaSK != null) {
            stringBuilder.append(":").append((Object)this.zzaSK);
        }
        if (this.zzaSM != null) {
            stringBuilder.append(":").append(this.zzaSM);
        }
        stringBuilder.append(":").append((Object)this.zzaSg);
        return stringBuilder.append("}").toString();
    }

    public String toDebugString() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7 = String.valueOf(DataSource.zzgC(this.type));
        String string8 = String.valueOf(this.zzaSg.zzCk());
        if (this.zzaSL == null) {
            string6 = "";
        } else if (this.zzaSL.equals((Object)zzb.zzaSo)) {
            string6 = ":gms";
        } else {
            String string9 = String.valueOf(this.zzaSL.getPackageName());
            string6 = string5 = string9.length() != 0 ? ":".concat(string9) : new String(":");
        }
        if (this.zzaSK != null) {
            string4 = String.valueOf(this.zzaSK.getModel());
            string3 = String.valueOf(this.zzaSK.getUid());
            string2 = new StringBuilder(2 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(":").append(string4).append(":").append(string3).toString();
        } else {
            string2 = string4 = "";
        }
        if (this.zzaSM != null) {
            String string10 = String.valueOf(this.zzaSM);
            string = string10.length() != 0 ? ":".concat(string10) : new String(":");
        } else {
            string = "";
        }
        string3 = string;
        return new StringBuilder(1 + String.valueOf(string7).length() + String.valueOf(string8).length() + String.valueOf(string5).length() + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string7).append(":").append(string8).append(string5).append(string4).append(string3).toString();
    }

    private static String zzgC(int n) {
        switch (n) {
            case 0: {
                return "r";
            }
            case 1: {
                return "d";
            }
            case 2: {
                return "c";
            }
            case 3: {
                return "v";
            }
        }
        return "?";
    }

    public static String zzgD(int n) {
        switch (n) {
            case 1: {
                return "blood_pressure_esh2002";
            }
            case 2: {
                return "blood_pressure_esh2010";
            }
            case 3: {
                return "blood_pressure_aami";
            }
            case 4: {
                return "blood_pressure_bhs_a_a";
            }
            case 5: {
                return "blood_pressure_bhs_a_b";
            }
            case 6: {
                return "blood_pressure_bhs_b_a";
            }
            case 7: {
                return "blood_pressure_bhs_b_b";
            }
            case 8: {
                return "blood_glucose_iso151972003";
            }
            case 9: {
                return "blood_glucose_iso151972013";
            }
        }
        return "unknown";
    }

    private String getTypeString() {
        switch (this.type) {
            case 0: {
                return "raw";
            }
            case 1: {
                return "derived";
            }
            case 2: {
                return "cleaned";
            }
            case 3: {
                return "converted";
            }
        }
        return "derived";
    }

    int getVersionCode() {
        return this.versionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzj.zza(this, parcel, n);
    }

    public static final class Builder {
        private DataType zzaSg;
        private int type = -1;
        private String name;
        private Device zzaSK;
        private zzb zzaSL;
        private String zzaSM = "";
        private int[] zzaSN;

        public Builder setDataType(DataType dataType) {
            this.zzaSg = dataType;
            return this;
        }

        public Builder setType(int n) {
            this.type = n;
            return this;
        }

        public Builder setName(String string) {
            this.name = string;
            return this;
        }

        public Builder setDevice(Device device) {
            this.zzaSK = device;
            return this;
        }

        public Builder setAppPackageName(String string) {
            this.zzaSL = zzb.zzdV(string);
            return this;
        }

        public Builder setAppPackageName(Context context) {
            return this.setAppPackageName(context.getPackageName());
        }

        public Builder setStreamName(String string) {
            zzac.zzb((string != null ? 1 : 0) != 0, (Object)"Must specify a valid stream name");
            this.zzaSM = string;
            return this;
        }

        public Builder setDataQualityStandards(int ... nArray) {
            this.zzaSN = nArray;
            return this;
        }

        public DataSource build() {
            zzac.zza((this.zzaSg != null ? 1 : 0) != 0, (Object)"Must set data type");
            zzac.zza((this.type >= 0 ? 1 : 0) != 0, (Object)"Must set data source type");
            return new DataSource(this);
        }
    }
}

