/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.safeparcel.zze;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.zzh;
import com.google.android.gms.internal.zzbvq;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataPoint
extends zza
implements ReflectedParcelable {
    private final int versionCode;
    private final DataSource zzaTe;
    private long zzaTz;
    private long zzaTA;
    private final Value[] zzaTB;
    private DataSource zzaTC;
    private long zzaTD;
    private long zzaTE;
    public static final Parcelable.Creator<DataPoint> CREATOR = new zzh();

    DataPoint(int n, DataSource dataSource, long l, long l2, Value[] valueArray, DataSource dataSource2, long l3, long l4) {
        this.versionCode = n;
        this.zzaTe = dataSource;
        this.zzaTC = dataSource2;
        this.zzaTz = l;
        this.zzaTA = l2;
        this.zzaTB = valueArray;
        this.zzaTD = l3;
        this.zzaTE = l4;
    }

    DataPoint(List<DataSource> list, RawDataPoint rawDataPoint) {
        this(DataPoint.zzc(list, rawDataPoint.zzaVd), DataPoint.zzc(list, rawDataPoint.zzaVe), rawDataPoint);
    }

    private DataPoint(DataSource dataSource, DataSource dataSource2, RawDataPoint rawDataPoint) {
        this(4, dataSource, DataPoint.zza(rawDataPoint.zzaVa, 0L), DataPoint.zza(rawDataPoint.zzaVb, 0L), rawDataPoint.zzaVc, dataSource2, DataPoint.zza(rawDataPoint.zzaVf, 0L), DataPoint.zza(rawDataPoint.zzaVg, 0L));
    }

    private static DataSource zzc(List<DataSource> list, int n) {
        if (n >= 0 && n < list.size()) {
            return list.get(n);
        }
        return null;
    }

    private DataPoint(DataSource dataSource) {
        this.versionCode = 4;
        this.zzaTe = (DataSource)((Object)zzbr.zzb((Object)((Object)dataSource), (Object)"Data source cannot be null"));
        List<Field> list = dataSource.getDataType().getFields();
        this.zzaTB = new Value[list.size()];
        int n = 0;
        for (Field field : list) {
            this.zzaTB[n] = new Value(field.getFormat());
            ++n;
        }
    }

    public static DataPoint create(DataSource dataSource) {
        return new DataPoint(dataSource);
    }

    public static DataPoint extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataPoint)zze.zza((Intent)intent, (String)"com.google.android.gms.fitness.EXTRA_DATA_POINT", CREATOR);
    }

    public final DataPoint setTimestamp(long l, TimeUnit timeUnit) {
        this.zzaTz = timeUnit.toNanos(l);
        if (this.getDataType() == DataType.TYPE_LOCATION_SAMPLE && zzbvq.zza(timeUnit)) {
            Log.w((String)"Fitness", (String)"Storing location at more than millisecond granularity is not supported. Extra precision is lost as the value is converted to milliseconds.");
            this.zzaTz = zzbvq.zza(this.zzaTz, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    public final DataPoint setTimeInterval(long l, long l2, TimeUnit timeUnit) {
        this.zzaTA = timeUnit.toNanos(l);
        this.zzaTz = timeUnit.toNanos(l2);
        return this;
    }

    public final Value zzaT(int n) {
        DataType dataType = this.getDataType();
        if (n < 0 || n >= dataType.getFields().size()) {
            throw new IllegalArgumentException(String.format("fieldIndex %s is out of range for %s", new Object[]{n, dataType}));
        }
        return this.zzaTB[n];
    }

    public final Value getValue(Field field) {
        int n = this.getDataType().indexOf(field);
        return this.zzaTB[n];
    }

    public final Value[] zztF() {
        return this.zzaTB;
    }

    public final DataPoint setFloatValues(float ... fArray) {
        this.zzaU(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            this.zzaTB[i].setFloat(fArray[i]);
        }
        return this;
    }

    public final DataPoint setIntValues(int ... nArray) {
        this.zzaU(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.zzaTB[i].setInt(nArray[i]);
        }
        return this;
    }

    private final void zzaU(int n) {
        List<Field> list = this.getDataType().getFields();
        int n2 = list.size();
        zzbr.zzb((n == n2 ? 1 : 0) != 0, (String)"Attempting to insert %s values, but needed %s: %s", (Object[])new Object[]{n, n2, list});
    }

    public final DataType getDataType() {
        return this.zzaTe.getDataType();
    }

    public final DataSource getDataSource() {
        return this.zzaTe;
    }

    public final DataSource getOriginalDataSource() {
        if (this.zzaTC != null) {
            return this.zzaTC;
        }
        return this.zzaTe;
    }

    public final DataSource zztG() {
        return this.zzaTC;
    }

    public final long getTimestamp(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaTz, TimeUnit.NANOSECONDS);
    }

    public final long zztH() {
        return this.zzaTD;
    }

    public final long zztI() {
        return this.zzaTE;
    }

    public final long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaTA, TimeUnit.NANOSECONDS);
    }

    public final long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaTz, TimeUnit.NANOSECONDS);
    }

    public final void zztJ() {
        DataSource dataSource = this.getDataSource();
        zzbr.zzb((boolean)this.getDataType().getName().equals(dataSource.getDataType().getName()), (String)"Conflicting data types found %s vs %s", (Object[])new Object[]{this.getDataType(), this.getDataType()});
        zzbr.zzb((this.zzaTz > 0L ? 1 : 0) != 0, (String)"Data point does not have the timestamp set: %s", (Object[])new Object[]{this});
        zzbr.zzb((this.zzaTA <= this.zzaTz ? 1 : 0) != 0, (String)"Data point with start time greater than end time found: %s", (Object[])new Object[]{this});
    }

    public final boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DataPoint)) break block3;
                DataPoint dataPoint = (DataPoint)((Object)object);
                DataPoint dataPoint2 = this;
                if (!(zzbh.equal((Object)((Object)dataPoint2.zzaTe), (Object)((Object)dataPoint.zzaTe)) && dataPoint2.zzaTz == dataPoint.zzaTz && dataPoint2.zzaTA == dataPoint.zzaTA && Arrays.equals((Object[])dataPoint2.zzaTB, (Object[])dataPoint.zzaTB) && zzbh.equal((Object)((Object)dataPoint2.getOriginalDataSource()), (Object)((Object)dataPoint.getOriginalDataSource())))) break block3;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaTe, this.zzaTz, this.zzaTA});
    }

    public final String toString() {
        return String.format("DataPoint{%s@[%s, %s,raw=%s,insert=%s](%s %s)}", Arrays.toString((Object[])this.zzaTB), this.zzaTA, this.zzaTz, this.zzaTD, this.zzaTE, this.zzaTe.toDebugString(), this.zzaTC != null ? this.zzaTC.toDebugString() : "N/A");
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataPoint dataPoint = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (Parcelable)dataPoint.getDataSource(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (long)dataPoint.zzaTz);
        zzd.zza((Parcel)parcel2, (int)4, (long)dataPoint.zzaTA);
        zzd.zza((Parcel)parcel2, (int)5, (Parcelable[])dataPoint.zzaTB, (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (Parcelable)dataPoint.zzaTC, (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (long)dataPoint.zzaTD);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)dataPoint.versionCode);
        zzd.zza((Parcel)parcel2, (int)8, (long)dataPoint.zzaTE);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    private static long zza(Long l, long l2) {
        if (l != null) {
            return l;
        }
        return 0L;
    }
}

