/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzap;
import com.google.android.gms.location.LocationRequest;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource zzaUh;
    private final DataType zzaUi;
    private final long zzaVn;
    private final long zzaXb;
    private final long zzaXa;
    private final int zzaVo;
    private final LocationRequest zzaXf;
    private final long zzaXg;

    private SensorRequest(Builder builder) {
        this.zzaUh = builder.zzaUh;
        this.zzaUi = builder.zzaUi;
        this.zzaVn = builder.zzaVn;
        this.zzaXb = builder.zzaXb;
        this.zzaXa = builder.zzaXa;
        this.zzaVo = builder.zzaVo;
        this.zzaXf = null;
        this.zzaXg = builder.zzaXg;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        int n;
        this.zzaXf = locationRequest;
        this.zzaVn = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.zzaXb = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.zzaXa = this.zzaVn;
        this.zzaUi = dataSource.getDataType();
        switch (locationRequest.getPriority()) {
            case 100: {
                n = 3;
                break;
            }
            case 104: {
                n = 1;
                break;
            }
            default: {
                n = 2;
            }
        }
        this.zzaVo = n;
        this.zzaUh = dataSource;
        long l = locationRequest.getExpirationTime();
        if (l == Long.MAX_VALUE) {
            this.zzaXg = Long.MAX_VALUE;
            return;
        }
        this.zzaXg = TimeUnit.MILLISECONDS.toMicros(l - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    public DataSource getDataSource() {
        return this.zzaUh;
    }

    public DataType getDataType() {
        return this.zzaUi;
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaVn, TimeUnit.MICROSECONDS);
    }

    public long getFastestRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaXb, TimeUnit.MICROSECONDS);
    }

    public long getMaxDeliveryLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaXa, TimeUnit.MICROSECONDS);
    }

    public int getAccuracyMode() {
        return this.zzaVo;
    }

    public final long zztV() {
        return this.zzaXg;
    }

    public String toString() {
        return zzbh.zzt((Object)this).zzg("dataSource", (Object)this.zzaUh).zzg("dataType", (Object)this.zzaUi).zzg("samplingRateMicros", (Object)this.zzaVn).zzg("deliveryLatencyMicros", (Object)this.zzaXa).zzg("timeOutMicros", (Object)this.zzaXg).toString();
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SensorRequest)) break block3;
                SensorRequest sensorRequest = (SensorRequest)object;
                SensorRequest sensorRequest2 = this;
                if (!(zzbh.equal((Object)((Object)sensorRequest2.zzaUh), (Object)((Object)sensorRequest.zzaUh)) && zzbh.equal((Object)((Object)sensorRequest2.zzaUi), (Object)((Object)sensorRequest.zzaUi)) && sensorRequest2.zzaVn == sensorRequest.zzaVn && sensorRequest2.zzaXb == sensorRequest.zzaXb && sensorRequest2.zzaXa == sensorRequest.zzaXa && sensorRequest2.zzaVo == sensorRequest.zzaVo && zzbh.equal((Object)sensorRequest2.zzaXf, (Object)sensorRequest.zzaXf) && sensorRequest2.zzaXg == sensorRequest.zzaXg)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaUh, this.zzaUi, this.zzaVn, this.zzaXb, this.zzaXa, this.zzaVo, this.zzaXf, this.zzaXg});
    }

    /* synthetic */ SensorRequest(Builder builder, zzap zzap2) {
        this(builder);
    }

    public static class Builder {
        private DataSource zzaUh;
        private DataType zzaUi;
        private long zzaVn = -1L;
        private long zzaXb = 0L;
        private long zzaXa = 0L;
        private boolean zzaXh = false;
        private int zzaVo = 2;
        private long zzaXg = Long.MAX_VALUE;

        public Builder setDataSource(DataSource dataSource) {
            this.zzaUh = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.zzaUi = dataType;
            return this;
        }

        public Builder setSamplingRate(long l, TimeUnit timeUnit) {
            zzbr.zzb((l >= 0L ? 1 : 0) != 0, (Object)"Cannot use a negative sampling interval");
            this.zzaVn = timeUnit.toMicros(l);
            if (!this.zzaXh) {
                this.zzaXb = this.zzaVn / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int n, TimeUnit timeUnit) {
            zzbr.zzb((n >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative interval");
            this.zzaXh = true;
            this.zzaXb = timeUnit.toMicros(n);
            return this;
        }

        public Builder setMaxDeliveryLatency(int n, TimeUnit timeUnit) {
            zzbr.zzb((n >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative delivery interval");
            this.zzaXa = timeUnit.toMicros(n);
            return this;
        }

        public Builder setAccuracyMode(int n) {
            int n2;
            switch (n) {
                case 1: 
                case 3: {
                    n2 = n;
                    break;
                }
                default: {
                    n2 = 2;
                }
            }
            this.zzaVo = n2;
            return this;
        }

        public Builder setTimeout(long l, TimeUnit timeUnit) {
            zzbr.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid time out value specified: %d", (Object[])new Object[]{l});
            zzbr.zzb((timeUnit != null ? 1 : 0) != 0, (Object)"Invalid time unit specified");
            this.zzaXg = timeUnit.toMicros(l);
            return this;
        }

        public SensorRequest build() {
            zzbr.zza((this.zzaUh != null || this.zzaUi != null ? 1 : 0) != 0, (Object)"Must call setDataSource() or setDataType()");
            zzbr.zza((this.zzaUi == null || this.zzaUh == null || this.zzaUi.equals((Object)this.zzaUh.getDataType()) ? 1 : 0) != 0, (Object)"Specified data type is incompatible with specified data source");
            return new SensorRequest(this, null);
        }
    }
}

