/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbj;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.result.zzc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DataReadResult
extends zza
implements Result {
    private final int zzakw;
    private final List<DataSet> zzaTu;
    private final Status mStatus;
    private final List<Bucket> zzaXy;
    private int zzaXz;
    private final List<DataSource> zzaXA;
    private final List<DataType> zzaXB;
    public static final Parcelable.Creator<DataReadResult> CREATOR = new zzc();

    DataReadResult(int n, List<RawDataSet> list, Status status, List<RawBucket> list2, int n2, List<DataSource> list3, List<DataType> list4) {
        this.zzakw = n;
        this.mStatus = status;
        this.zzaXz = n2;
        this.zzaXA = list3;
        this.zzaXB = list4;
        this.zzaTu = new ArrayList<DataSet>(list.size());
        for (RawDataSet zza2 : list) {
            this.zzaTu.add(new DataSet(zza2, list3));
        }
        this.zzaXy = new ArrayList<Bucket>(list2.size());
        for (RawBucket rawBucket : list2) {
            this.zzaXy.add(new Bucket(rawBucket, list3));
        }
    }

    private DataReadResult(List<DataSet> list, List<Bucket> list2, Status status) {
        this.zzakw = 5;
        this.zzaTu = list;
        this.mStatus = status;
        this.zzaXy = list2;
        this.zzaXz = 1;
        this.zzaXA = new ArrayList<DataSource>();
        this.zzaXB = new ArrayList<DataType>();
    }

    public static DataReadResult zza(Status status, List<DataType> list, List<DataSource> list2) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataSource zza2 : list2) {
            arrayList.add(DataSet.create(zza2));
        }
        for (DataType dataType : list) {
            DataSource dataSource = new DataSource.Builder().setDataType(dataType).setType(1).setName("Default").build();
            arrayList.add(DataSet.create(dataSource));
        }
        return new DataReadResult(arrayList, Collections.emptyList(), status);
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzaTu) {
            if (!dataType.equals((Object)dataSet.getDataType())) continue;
            return dataSet;
        }
        return DataSet.create(new DataSource.Builder().setDataType(dataType).setType(1).build());
    }

    public DataSet getDataSet(DataSource dataSource) {
        for (DataSet dataSet : this.zzaTu) {
            if (!dataSource.equals((Object)dataSet.getDataSource())) continue;
            return dataSet;
        }
        return DataSet.create(dataSource);
    }

    public List<DataSet> getDataSets() {
        return this.zzaTu;
    }

    public List<Bucket> getBuckets() {
        return this.zzaXy;
    }

    public final int zztW() {
        return this.zzaXz;
    }

    public final void zzb(DataReadResult dataReadResult) {
        Iterator<zza> iterator = dataReadResult.getDataSets().iterator();
        while (iterator.hasNext()) {
            DataReadResult.zza(iterator.next(), this.zzaTu);
        }
        block1: for (Bucket bucket : dataReadResult.getBuckets()) {
            List<Bucket> list = this.zzaXy;
            Bucket bucket2 = bucket;
            DataReadResult dataReadResult2 = this;
            for (Bucket bucket3 : list) {
                if (!bucket3.zza(bucket2)) continue;
                Iterator<DataSet> iterator2 = bucket2.getDataSets().iterator();
                while (iterator2.hasNext()) {
                    DataReadResult.zza(iterator2.next(), bucket3.getDataSets());
                }
                continue block1;
            }
            dataReadResult2.zzaXy.add(bucket2);
        }
    }

    private static void zza(DataSet dataSet, List<DataSet> list) {
        for (DataSet dataSet2 : list) {
            if (!dataSet2.getDataSource().equals((Object)dataSet.getDataSource())) continue;
            dataSet2.zzb(dataSet.getDataPoints());
            return;
        }
        list.add(dataSet);
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DataReadResult)) break block3;
                DataReadResult dataReadResult = (DataReadResult)((Object)object);
                DataReadResult dataReadResult2 = this;
                if (!(dataReadResult2.mStatus.equals((Object)dataReadResult.mStatus) && zzbh.equal(dataReadResult2.zzaTu, dataReadResult.zzaTu) && zzbh.equal(dataReadResult2.zzaXy, dataReadResult.zzaXy))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.mStatus, this.zzaTu, this.zzaXy});
    }

    public String toString() {
        Object object;
        Object object2;
        int n;
        zzbj zzbj2 = zzbh.zzt((Object)((Object)this)).zzg("status", (Object)this.mStatus);
        if (this.zzaTu.size() > 5) {
            n = this.zzaTu.size();
            object2 = new StringBuilder(21).append(n).append(" data sets").toString();
        } else {
            object2 = this.zzaTu;
        }
        zzbj zzbj3 = zzbj2.zzg("dataSets", object2);
        if (this.zzaXy.size() > 5) {
            n = this.zzaXy.size();
            object = new StringBuilder(19).append(n).append(" buckets").toString();
        } else {
            object = this.zzaXy;
        }
        return zzbj3.zzg("buckets", object).toString();
    }

    private List<RawBucket> zztX() {
        ArrayList<RawBucket> arrayList = new ArrayList<RawBucket>(this.zzaXy.size());
        for (Bucket bucket : this.zzaXy) {
            arrayList.add(new RawBucket(bucket, this.zzaXA, this.zzaXB));
        }
        return arrayList;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataReadResult dataReadResult = this;
        int n2 = zzd.zze((Parcel)parcel2);
        DataReadResult dataReadResult2 = dataReadResult;
        ArrayList<RawDataSet> arrayList = new ArrayList<RawDataSet>(dataReadResult2.zzaTu.size());
        for (DataSet dataSet : dataReadResult2.zzaTu) {
            arrayList.add(new RawDataSet(dataSet, dataReadResult2.zzaXA, dataReadResult2.zzaXB));
        }
        zzd.zzd((Parcel)parcel2, (int)1, arrayList, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (Parcelable)dataReadResult.getStatus(), (int)n, (boolean)false);
        zzd.zzd((Parcel)parcel2, (int)3, dataReadResult.zztX(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)5, (int)dataReadResult.zzaXz);
        zzd.zzc((Parcel)parcel2, (int)6, dataReadResult.zzaXA, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)7, dataReadResult.zzaXB, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)dataReadResult.zzakw);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

