/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zze;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.request.DataUpdateListenerRegistrationRequest;
import com.google.android.gms.fitness.request.DataUpdateRequest;
import com.google.android.gms.fitness.result.DailyTotalResult;
import com.google.android.gms.fitness.result.DataReadResult;
import java.util.concurrent.TimeUnit;

public interface HistoryApi {
    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.BODY_SENSORS"}, conditional=true)
    public PendingResult<DataReadResult> readData(GoogleApiClient var1, DataReadRequest var2);

    public PendingResult<DailyTotalResult> readDailyTotal(GoogleApiClient var1, DataType var2);

    public PendingResult<DailyTotalResult> readDailyTotalFromLocalDevice(GoogleApiClient var1, DataType var2);

    public PendingResult<Status> insertData(GoogleApiClient var1, DataSet var2);

    public PendingResult<Status> deleteData(GoogleApiClient var1, DataDeleteRequest var2);

    public PendingResult<Status> updateData(GoogleApiClient var1, DataUpdateRequest var2);

    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.BODY_SENSORS"}, conditional=true)
    public PendingResult<Status> registerDataUpdateListener(GoogleApiClient var1, DataUpdateListenerRegistrationRequest var2);

    public PendingResult<Status> unregisterDataUpdateListener(GoogleApiClient var1, PendingIntent var2);

    public static class ViewIntentBuilder {
        private final Context zzqF;
        private final DataType zzaSZ;
        private DataSource zzaTa;
        private long zzaTb;
        private long zzaTc;
        private String zzaTd;

        public ViewIntentBuilder(Context context, DataType dataType) {
            this.zzqF = context;
            this.zzaSZ = dataType;
        }

        public ViewIntentBuilder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            this.zzaTb = timeUnit.toMillis(l);
            this.zzaTc = timeUnit.toMillis(l2);
            return this;
        }

        public ViewIntentBuilder setDataSource(DataSource dataSource) {
            zzbo.zzb((boolean)dataSource.getDataType().equals((Object)this.zzaSZ), (String)"Data source %s is not for the data type %s", (Object[])new Object[]{dataSource, this.zzaSZ});
            this.zzaTa = dataSource;
            return this;
        }

        public ViewIntentBuilder setPreferredApplication(String string) {
            this.zzaTd = string;
            return this;
        }

        public Intent build() {
            zzbo.zza((this.zzaTb > 0L ? 1 : 0) != 0, (Object)"Start time must be set");
            zzbo.zza((this.zzaTc > this.zzaTb ? 1 : 0) != 0, (Object)"End time must be set and after start time");
            Intent intent = new Intent("vnd.google.fitness.VIEW");
            intent.setType(DataType.getMimeType(this.zzaTa.getDataType()));
            intent.putExtra("vnd.google.fitness.start_time", this.zzaTb);
            intent.putExtra("vnd.google.fitness.end_time", this.zzaTc);
            zze.zza((SafeParcelable)this.zzaTa, (Intent)intent, (String)"vnd.google.fitness.data_source");
            Intent intent2 = intent;
            ViewIntentBuilder viewIntentBuilder = this;
            if (viewIntentBuilder.zzaTd != null) {
                Intent intent3 = new Intent(intent2).setPackage(viewIntentBuilder.zzaTd);
                ResolveInfo resolveInfo = viewIntentBuilder.zzqF.getPackageManager().resolveActivity(intent3, 0);
                if (resolveInfo != null) {
                    String string = resolveInfo.activityInfo.name;
                    intent3.setComponent(new ComponentName(viewIntentBuilder.zzaTd, string));
                    return intent3;
                }
            }
            return intent2;
        }
    }
}

