/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzh;
import com.google.android.gms.fitness.request.zzi;
import com.google.android.gms.internal.zzbxf;
import com.google.android.gms.internal.zzbxg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
extends zza {
    private final int zzaku;
    private final long zzagZ;
    private final long zzaTo;
    private final List<DataSource> zzaWr;
    private final List<DataType> zzaTn;
    private final List<Session> zzaWs;
    private final boolean zzaWt;
    private final boolean zzaWu;
    private final zzbxf zzaWo;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new zzi();

    DataDeleteRequest(int n, long l, long l2, List<DataSource> list, List<DataType> list2, List<Session> list3, boolean bl, boolean bl2, IBinder iBinder) {
        this.zzaku = n;
        this.zzagZ = l;
        this.zzaTo = l2;
        this.zzaWr = Collections.unmodifiableList(list);
        this.zzaTn = Collections.unmodifiableList(list2);
        this.zzaWs = list3;
        this.zzaWt = bl;
        this.zzaWu = bl2;
        this.zzaWo = zzbxg.zzW(iBinder);
    }

    private DataDeleteRequest(Builder builder) {
        this(builder.zzagZ, builder.zzaTo, builder.zzaWr, builder.zzaTn, builder.zzaWs, builder.zzaWt, builder.zzaWu, null);
    }

    public DataDeleteRequest(DataDeleteRequest dataDeleteRequest, zzbxf zzbxf2) {
        this(dataDeleteRequest.zzagZ, dataDeleteRequest.zzaTo, dataDeleteRequest.zzaWr, dataDeleteRequest.zzaTn, dataDeleteRequest.zzaWs, dataDeleteRequest.zzaWt, dataDeleteRequest.zzaWu, zzbxf2);
    }

    private DataDeleteRequest(long l, long l2, List<DataSource> list, List<DataType> list2, List<Session> list3, boolean bl, boolean bl2, zzbxf zzbxf2) {
        this.zzaku = 3;
        this.zzagZ = l;
        this.zzaTo = l2;
        this.zzaWr = Collections.unmodifiableList(list);
        this.zzaTn = Collections.unmodifiableList(list2);
        this.zzaWs = list3;
        this.zzaWt = bl;
        this.zzaWu = bl2;
        this.zzaWo = zzbxf2;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzagZ, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaTo, TimeUnit.MILLISECONDS);
    }

    public List<DataSource> getDataSources() {
        return this.zzaWr;
    }

    public List<DataType> getDataTypes() {
        return this.zzaTn;
    }

    public List<Session> getSessions() {
        return this.zzaWs;
    }

    public boolean deleteAllData() {
        return this.zzaWt;
    }

    public boolean deleteAllSessions() {
        return this.zzaWu;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof DataDeleteRequest)) break block3;
                DataDeleteRequest dataDeleteRequest = (DataDeleteRequest)((Object)object);
                DataDeleteRequest dataDeleteRequest2 = this;
                if (!(dataDeleteRequest2.zzagZ == dataDeleteRequest.zzagZ && dataDeleteRequest2.zzaTo == dataDeleteRequest.zzaTo && zzbe.equal(dataDeleteRequest2.zzaWr, dataDeleteRequest.zzaWr) && zzbe.equal(dataDeleteRequest2.zzaTn, dataDeleteRequest.zzaTn) && zzbe.equal(dataDeleteRequest2.zzaWs, dataDeleteRequest.zzaWs) && dataDeleteRequest2.zzaWt == dataDeleteRequest.zzaWt && dataDeleteRequest2.zzaWu == dataDeleteRequest.zzaWu)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzagZ, this.zzaTo});
    }

    public String toString() {
        return zzbe.zzt((Object)((Object)this)).zzg("startTimeMillis", (Object)this.zzagZ).zzg("endTimeMillis", (Object)this.zzaTo).zzg("dataSources", this.zzaWr).zzg("dateTypes", this.zzaTn).zzg("sessions", this.zzaWs).zzg("deleteAllData", (Object)this.zzaWt).zzg("deleteAllSessions", (Object)this.zzaWu).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataDeleteRequest dataDeleteRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (long)dataDeleteRequest.zzagZ);
        zzd.zza((Parcel)parcel2, (int)2, (long)dataDeleteRequest.zzaTo);
        zzd.zzc((Parcel)parcel2, (int)3, dataDeleteRequest.getDataSources(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)4, dataDeleteRequest.getDataTypes(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)5, dataDeleteRequest.getSessions(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (boolean)dataDeleteRequest.zzaWt);
        zzd.zza((Parcel)parcel2, (int)7, (boolean)dataDeleteRequest.zzaWu);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)dataDeleteRequest.zzaku);
        DataDeleteRequest dataDeleteRequest2 = dataDeleteRequest;
        zzd.zza((Parcel)parcel2, (int)8, (IBinder)(dataDeleteRequest2.zzaWo == null ? null : dataDeleteRequest2.zzaWo.asBinder()), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ DataDeleteRequest(Builder builder, zzh zzh2) {
        this(builder);
    }

    public static class Builder {
        private long zzagZ;
        private long zzaTo;
        private List<DataSource> zzaWr = new ArrayList<DataSource>();
        private List<DataType> zzaTn = new ArrayList<DataType>();
        private List<Session> zzaWs = new ArrayList<Session>();
        private boolean zzaWt = false;
        private boolean zzaWu = false;

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            zzbo.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{l});
            zzbo.zzb((l2 > l ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{l2});
            this.zzagZ = timeUnit.toMillis(l);
            this.zzaTo = timeUnit.toMillis(l2);
            return this;
        }

        public Builder deleteAllData() {
            zzbo.zzb((boolean)this.zzaTn.isEmpty(), (Object)"Specific data type already added for deletion. deleteAllData() will delete all data types and cannot be combined with addDataType()");
            zzbo.zzb((boolean)this.zzaWr.isEmpty(), (Object)"Specific data source already added for deletion. deleteAllData() will delete all data sources and cannot be combined with addDataSource()");
            this.zzaWt = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            zzbo.zzb((!this.zzaWt ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataType() cannot be combined with deleteAllData()");
            zzbo.zzb((dataType != null ? 1 : 0) != 0, (Object)"Must specify a valid data type");
            if (!this.zzaTn.contains((Object)dataType)) {
                this.zzaTn.add(dataType);
            }
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            zzbo.zzb((!this.zzaWt ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataSource() cannot be combined with deleteAllData()");
            zzbo.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Must specify a valid data source");
            if (!this.zzaWr.contains((Object)dataSource)) {
                this.zzaWr.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            zzbo.zzb((!this.zzaWu ? 1 : 0) != 0, (Object)"All sessions already marked for deletion.  addSession() cannot be combined with deleteAllSessions()");
            zzbo.zzb((session != null ? 1 : 0) != 0, (Object)"Must specify a valid session");
            zzbo.zzb((session.getEndTime(TimeUnit.MILLISECONDS) > 0L ? 1 : 0) != 0, (Object)"Cannot delete an ongoing session. Please stop the session prior to deleting it");
            this.zzaWs.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            zzbo.zzb((boolean)this.zzaWs.isEmpty(), (Object)"Specific session already added for deletion. deleteAllData() will delete all sessions and cannot be combined with addSession()");
            this.zzaWu = true;
            return this;
        }

        public DataDeleteRequest build() {
            zzbo.zza((this.zzagZ > 0L && this.zzaTo > this.zzagZ ? 1 : 0) != 0, (Object)"Must specify a valid time interval");
            boolean bl = this.zzaWt || !this.zzaWr.isEmpty() || !this.zzaTn.isEmpty();
            boolean bl2 = this.zzaWu || !this.zzaWs.isEmpty();
            zzbo.zza((bl || bl2 ? 1 : 0) != 0, (Object)"No data or session marked for deletion");
            Builder builder = this;
            if (!builder.zzaWs.isEmpty()) {
                for (Session session : builder.zzaWs) {
                    zzbo.zza((session.getStartTime(TimeUnit.MILLISECONDS) >= builder.zzagZ && session.getEndTime(TimeUnit.MILLISECONDS) <= builder.zzaTo ? 1 : 0) != 0, (String)"Session %s is outside the time interval [%d, %d]", (Object[])new Object[]{session, builder.zzagZ, builder.zzaTo});
                }
            }
            return new DataDeleteRequest(this, null);
        }
    }
}

