/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzap;
import com.google.android.gms.location.LocationRequest;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource zzaUd;
    private final DataType zzaUe;
    private final long zzaVj;
    private final long zzaWX;
    private final long zzaWW;
    private final int zzaVk;
    private final LocationRequest zzaXb;
    private final long zzaXc;

    private SensorRequest(Builder builder) {
        this.zzaUd = builder.zzaUd;
        this.zzaUe = builder.zzaUe;
        this.zzaVj = builder.zzaVj;
        this.zzaWX = builder.zzaWX;
        this.zzaWW = builder.zzaWW;
        this.zzaVk = builder.zzaVk;
        this.zzaXb = null;
        this.zzaXc = builder.zzaXc;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        int n;
        this.zzaXb = locationRequest;
        this.zzaVj = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.zzaWX = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.zzaWW = this.zzaVj;
        this.zzaUe = dataSource.getDataType();
        switch (locationRequest.getPriority()) {
            case 100: {
                n = 3;
                break;
            }
            case 104: {
                n = 1;
                break;
            }
            default: {
                n = 2;
            }
        }
        this.zzaVk = n;
        this.zzaUd = dataSource;
        long l = locationRequest.getExpirationTime();
        if (l == Long.MAX_VALUE) {
            this.zzaXc = Long.MAX_VALUE;
            return;
        }
        this.zzaXc = TimeUnit.MILLISECONDS.toMicros(l - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    public DataSource getDataSource() {
        return this.zzaUd;
    }

    public DataType getDataType() {
        return this.zzaUe;
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaVj, TimeUnit.MICROSECONDS);
    }

    public long getFastestRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaWX, TimeUnit.MICROSECONDS);
    }

    public long getMaxDeliveryLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaWW, TimeUnit.MICROSECONDS);
    }

    public int getAccuracyMode() {
        return this.zzaVk;
    }

    public final long zztW() {
        return this.zzaXc;
    }

    public String toString() {
        return zzbe.zzt((Object)this).zzg("dataSource", (Object)this.zzaUd).zzg("dataType", (Object)this.zzaUe).zzg("samplingRateMicros", (Object)this.zzaVj).zzg("deliveryLatencyMicros", (Object)this.zzaWW).zzg("timeOutMicros", (Object)this.zzaXc).toString();
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SensorRequest)) break block3;
                SensorRequest sensorRequest = (SensorRequest)object;
                SensorRequest sensorRequest2 = this;
                if (!(zzbe.equal((Object)((Object)sensorRequest2.zzaUd), (Object)((Object)sensorRequest.zzaUd)) && zzbe.equal((Object)((Object)sensorRequest2.zzaUe), (Object)((Object)sensorRequest.zzaUe)) && sensorRequest2.zzaVj == sensorRequest.zzaVj && sensorRequest2.zzaWX == sensorRequest.zzaWX && sensorRequest2.zzaWW == sensorRequest.zzaWW && sensorRequest2.zzaVk == sensorRequest.zzaVk && zzbe.equal((Object)sensorRequest2.zzaXb, (Object)sensorRequest.zzaXb) && sensorRequest2.zzaXc == sensorRequest.zzaXc)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaUd, this.zzaUe, this.zzaVj, this.zzaWX, this.zzaWW, this.zzaVk, this.zzaXb, this.zzaXc});
    }

    /* synthetic */ SensorRequest(Builder builder, zzap zzap2) {
        this(builder);
    }

    public static class Builder {
        private DataSource zzaUd;
        private DataType zzaUe;
        private long zzaVj = -1L;
        private long zzaWX = 0L;
        private long zzaWW = 0L;
        private boolean zzaXd = false;
        private int zzaVk = 2;
        private long zzaXc = Long.MAX_VALUE;

        public Builder setDataSource(DataSource dataSource) {
            this.zzaUd = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.zzaUe = dataType;
            return this;
        }

        public Builder setSamplingRate(long l, TimeUnit timeUnit) {
            zzbo.zzb((l >= 0L ? 1 : 0) != 0, (Object)"Cannot use a negative sampling interval");
            this.zzaVj = timeUnit.toMicros(l);
            if (!this.zzaXd) {
                this.zzaWX = this.zzaVj / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int n, TimeUnit timeUnit) {
            zzbo.zzb((n >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative interval");
            this.zzaXd = true;
            this.zzaWX = timeUnit.toMicros(n);
            return this;
        }

        public Builder setMaxDeliveryLatency(int n, TimeUnit timeUnit) {
            zzbo.zzb((n >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative delivery interval");
            this.zzaWW = timeUnit.toMicros(n);
            return this;
        }

        public Builder setAccuracyMode(int n) {
            int n2;
            switch (n) {
                case 1: 
                case 3: {
                    n2 = n;
                    break;
                }
                default: {
                    n2 = 2;
                }
            }
            this.zzaVk = n2;
            return this;
        }

        public Builder setTimeout(long l, TimeUnit timeUnit) {
            zzbo.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid time out value specified: %d", (Object[])new Object[]{l});
            zzbo.zzb((timeUnit != null ? 1 : 0) != 0, (Object)"Invalid time unit specified");
            this.zzaXc = timeUnit.toMicros(l);
            return this;
        }

        public SensorRequest build() {
            zzbo.zza((this.zzaUd != null || this.zzaUe != null ? 1 : 0) != 0, (Object)"Must call setDataSource() or setDataType()");
            zzbo.zza((this.zzaUe == null || this.zzaUd == null || this.zzaUe.equals((Object)this.zzaUd.getDataType()) ? 1 : 0) != 0, (Object)"Specified data type is incompatible with specified data source");
            return new SensorRequest(this, null);
        }
    }
}

