/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzas;
import com.google.android.gms.fitness.request.zzat;
import com.google.android.gms.internal.zzbue;
import com.google.android.gms.internal.zzbxg;
import com.google.android.gms.internal.zzbxh;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionInsertRequest
extends zza {
    private final int versionCode;
    private final Session zzaXe;
    private final List<DataSet> zzaXf;
    private final List<DataPoint> zzaXg;
    private final zzbxg zzaXh;
    public static final Parcelable.Creator<SessionInsertRequest> CREATOR = new zzat();

    SessionInsertRequest(int n, Session session, List<DataSet> list, List<DataPoint> list2, IBinder iBinder) {
        this.versionCode = n;
        this.zzaXe = session;
        this.zzaXf = Collections.unmodifiableList(list);
        this.zzaXg = Collections.unmodifiableList(list2);
        this.zzaXh = zzbxh.zzW(iBinder);
    }

    private SessionInsertRequest(Builder builder) {
        this(builder.zzaXe, builder.zzaXf, builder.zzaXg, null);
    }

    public SessionInsertRequest(SessionInsertRequest sessionInsertRequest, zzbxg zzbxg2) {
        this(sessionInsertRequest.zzaXe, sessionInsertRequest.zzaXf, sessionInsertRequest.zzaXg, zzbxg2);
    }

    private SessionInsertRequest(Session session, List<DataSet> list, List<DataPoint> list2, zzbxg zzbxg2) {
        this.versionCode = 3;
        this.zzaXe = session;
        this.zzaXf = Collections.unmodifiableList(list);
        this.zzaXg = Collections.unmodifiableList(list2);
        this.zzaXh = zzbxg2;
    }

    public Session getSession() {
        return this.zzaXe;
    }

    public List<DataSet> getDataSets() {
        return this.zzaXf;
    }

    public List<DataPoint> getAggregateDataPoints() {
        return this.zzaXg;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof SessionInsertRequest)) break block3;
                SessionInsertRequest sessionInsertRequest = (SessionInsertRequest)((Object)object);
                SessionInsertRequest sessionInsertRequest2 = this;
                if (!(zzbe.equal((Object)((Object)sessionInsertRequest2.zzaXe), (Object)((Object)sessionInsertRequest.zzaXe)) && zzbe.equal(sessionInsertRequest2.zzaXf, sessionInsertRequest.zzaXf) && zzbe.equal(sessionInsertRequest2.zzaXg, sessionInsertRequest.zzaXg))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaXe, this.zzaXf, this.zzaXg});
    }

    public String toString() {
        return zzbe.zzt((Object)((Object)this)).zzg("session", (Object)this.zzaXe).zzg("dataSets", this.zzaXf).zzg("aggregateDataPoints", this.zzaXg).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SessionInsertRequest sessionInsertRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (Parcelable)sessionInsertRequest.getSession(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)2, sessionInsertRequest.getDataSets(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)3, sessionInsertRequest.getAggregateDataPoints(), (boolean)false);
        SessionInsertRequest sessionInsertRequest2 = sessionInsertRequest;
        zzd.zza((Parcel)parcel2, (int)4, (IBinder)(sessionInsertRequest2.zzaXh == null ? null : sessionInsertRequest2.zzaXh.asBinder()), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)sessionInsertRequest.versionCode);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ SessionInsertRequest(Builder builder, zzas zzas2) {
        this(builder);
    }

    public static class Builder {
        private Session zzaXe;
        private List<DataSet> zzaXf = new ArrayList<DataSet>();
        private List<DataPoint> zzaXg = new ArrayList<DataPoint>();
        private List<DataSource> zzaXi = new ArrayList<DataSource>();

        public Builder setSession(Session session) {
            this.zzaXe = session;
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            zzbo.zzb((dataSet != null ? 1 : 0) != 0, (Object)"Must specify a valid data set.");
            DataSource dataSource = dataSet.getDataSource();
            zzbo.zza((!this.zzaXi.contains((Object)dataSource) ? 1 : 0) != 0, (String)"Data set for this data source %s is already added.", (Object[])new Object[]{dataSource});
            zzbo.zzb((!dataSet.getDataPoints().isEmpty() ? 1 : 0) != 0, (Object)"No data points specified in the input data set.");
            this.zzaXi.add(dataSource);
            this.zzaXf.add(dataSet);
            return this;
        }

        public Builder addAggregateDataPoint(DataPoint dataPoint) {
            zzbo.zzb((dataPoint != null ? 1 : 0) != 0, (Object)"Must specify a valid aggregate data point.");
            DataSource dataSource = dataPoint.getDataSource();
            zzbo.zza((!this.zzaXi.contains((Object)dataSource) ? 1 : 0) != 0, (String)"Data set/Aggregate data point for this data source %s is already added.", (Object[])new Object[]{dataSource});
            DataSet.zzb(dataPoint);
            this.zzaXi.add(dataSource);
            this.zzaXg.add(dataPoint);
            return this;
        }

        public SessionInsertRequest build() {
            zzbo.zza((this.zzaXe != null ? 1 : 0) != 0, (Object)"Must specify a valid session.");
            zzbo.zza((this.zzaXe.getEndTime(TimeUnit.MILLISECONDS) != 0L ? 1 : 0) != 0, (Object)"Must specify a valid end time, cannot insert a continuing session.");
            Builder builder = this;
            Iterator<zza> iterator = builder.zzaXf.iterator();
            while (iterator.hasNext()) {
                for (DataPoint dataPoint : iterator.next().getDataPoints()) {
                    builder.zzd(dataPoint);
                }
            }
            for (DataPoint dataPoint : builder.zzaXg) {
                builder.zzd(dataPoint);
            }
            return new SessionInsertRequest(this, null);
        }

        private final void zzd(DataPoint dataPoint) {
            DataPoint dataPoint2 = dataPoint;
            Builder builder = this;
            long l = builder.zzaXe.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = builder.zzaXe.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint2.getTimestamp(TimeUnit.NANOSECONDS);
            if (l3 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l3 < l || l3 > l2) {
                    l3 = zzbue.zza(l3, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzbo.zza((l3 >= l && l3 <= l2 ? 1 : 0) != 0, (String)"Data point %s has time stamp outside session interval [%d, %d]", (Object[])new Object[]{dataPoint2, l, l2});
                if (dataPoint2.getTimestamp(TimeUnit.NANOSECONDS) != l3) {
                    Log.w((String)"Fitness", (String)String.format("Data point timestamp [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint2.getTimestamp(TimeUnit.NANOSECONDS), l3, timeUnit}));
                    dataPoint2.setTimestamp(l3, TimeUnit.NANOSECONDS);
                }
            }
            dataPoint2 = dataPoint;
            builder = this;
            l = builder.zzaXe.getStartTime(TimeUnit.NANOSECONDS);
            l2 = builder.zzaXe.getEndTime(TimeUnit.NANOSECONDS);
            l3 = dataPoint2.getStartTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint2.getEndTime(TimeUnit.NANOSECONDS);
            if (l3 != 0L && l4 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l4 > l2) {
                    l4 = zzbue.zza(l4, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzbo.zza((l3 >= l && l4 <= l2 ? 1 : 0) != 0, (String)"Data point %s has start and end times outside session interval [%d, %d]", (Object[])new Object[]{dataPoint2, l, l2});
                if (l4 != dataPoint2.getEndTime(TimeUnit.NANOSECONDS)) {
                    Log.w((String)"Fitness", (String)String.format("Data point end time [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint2.getEndTime(TimeUnit.NANOSECONDS), l4, timeUnit}));
                    dataPoint2.setTimeInterval(l3, l4, TimeUnit.NANOSECONDS);
                }
            }
        }
    }
}

