/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.result.zzd;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DataSourcesResult
extends zza
implements Result {
    private final int versionCode;
    private final List<DataSource> zzaXy;
    private final Status zzajl;
    public static final Parcelable.Creator<DataSourcesResult> CREATOR = new zzd();

    DataSourcesResult(int n, List<DataSource> list, Status status) {
        this.versionCode = n;
        this.zzaXy = Collections.unmodifiableList(list);
        this.zzajl = status;
    }

    public DataSourcesResult(List<DataSource> list, Status status) {
        this.versionCode = 3;
        this.zzaXy = Collections.unmodifiableList(list);
        this.zzajl = status;
    }

    public List<DataSource> getDataSources() {
        return this.zzaXy;
    }

    public List<DataSource> getDataSources(DataType dataType) {
        ArrayList<DataSource> arrayList = new ArrayList<DataSource>();
        for (DataSource dataSource : this.zzaXy) {
            if (!dataSource.getDataType().equals((Object)dataType)) continue;
            arrayList.add(dataSource);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Status getStatus() {
        return this.zzajl;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DataSourcesResult)) break block3;
                DataSourcesResult dataSourcesResult = (DataSourcesResult)((Object)object);
                DataSourcesResult dataSourcesResult2 = this;
                if (!(dataSourcesResult2.zzajl.equals((Object)dataSourcesResult.zzajl) && zzbe.equal(dataSourcesResult2.zzaXy, dataSourcesResult.zzaXy))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzajl, this.zzaXy});
    }

    public String toString() {
        return zzbe.zzt((Object)((Object)this)).zzg("status", (Object)this.zzajl).zzg("dataSources", this.zzaXy).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataSourcesResult dataSourcesResult = this;
        int n2 = com.google.android.gms.common.internal.safeparcel.zzd.zze((Parcel)parcel2);
        com.google.android.gms.common.internal.safeparcel.zzd.zzc((Parcel)parcel2, (int)1, dataSourcesResult.getDataSources(), (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)2, (Parcelable)dataSourcesResult.getStatus(), (int)n, (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zzc((Parcel)parcel2, (int)1000, (int)dataSourcesResult.versionCode);
        com.google.android.gms.common.internal.safeparcel.zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

