/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.request.zzx;
import com.google.android.gms.fitness.request.zzy;
import com.google.android.gms.internal.zzbxg;
import com.google.android.gms.internal.zzbxh;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class DataUpdateRequest
extends zza {
    private final int zzaku;
    private final long zzagZ;
    private final long zzaTo;
    private final DataSet zzaVi;
    private final zzbxg zzaWo;
    public static final Parcelable.Creator<DataUpdateRequest> CREATOR = new zzy();

    DataUpdateRequest(int n, long l, long l2, DataSet dataSet, IBinder iBinder) {
        this.zzaku = n;
        this.zzagZ = l;
        this.zzaTo = l2;
        this.zzaVi = dataSet;
        this.zzaWo = zzbxh.zzW(iBinder);
    }

    private DataUpdateRequest(Builder builder) {
        this(builder.zzagZ, builder.zzaTo, builder.zzaVi, null);
    }

    private DataUpdateRequest(long l, long l2, DataSet dataSet, IBinder iBinder) {
        this.zzaku = 1;
        this.zzagZ = l;
        this.zzaTo = l2;
        this.zzaVi = dataSet;
        this.zzaWo = zzbxh.zzW(iBinder);
    }

    public DataUpdateRequest(DataUpdateRequest dataUpdateRequest, IBinder iBinder) {
        this(dataUpdateRequest.zzagZ, dataUpdateRequest.zzaTo, dataUpdateRequest.getDataSet(), iBinder);
    }

    public final long zzmc() {
        return this.zzagZ;
    }

    public final long zztU() {
        return this.zzaTo;
    }

    public DataSet getDataSet() {
        return this.zzaVi;
    }

    public IBinder getCallbackBinder() {
        if (this.zzaWo == null) {
            return null;
        }
        return this.zzaWo.asBinder();
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzagZ, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaTo, TimeUnit.MILLISECONDS);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof DataUpdateRequest)) break block3;
                DataUpdateRequest dataUpdateRequest = (DataUpdateRequest)((Object)object);
                DataUpdateRequest dataUpdateRequest2 = this;
                if (!(dataUpdateRequest2.zzagZ == dataUpdateRequest.zzagZ && dataUpdateRequest2.zzaTo == dataUpdateRequest.zzaTo && zzbe.equal((Object)((Object)dataUpdateRequest2.zzaVi), (Object)((Object)dataUpdateRequest.zzaVi)))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzagZ, this.zzaTo, this.zzaVi});
    }

    public String toString() {
        return zzbe.zzt((Object)((Object)this)).zzg("startTimeMillis", (Object)this.zzagZ).zzg("endTimeMillis", (Object)this.zzaTo).zzg("dataSet", (Object)this.zzaVi).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataUpdateRequest dataUpdateRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (long)dataUpdateRequest.zzagZ);
        zzd.zza((Parcel)parcel2, (int)2, (long)dataUpdateRequest.zzaTo);
        zzd.zza((Parcel)parcel2, (int)3, (Parcelable)dataUpdateRequest.getDataSet(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (IBinder)dataUpdateRequest.getCallbackBinder(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)dataUpdateRequest.zzaku);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ DataUpdateRequest(Builder builder, zzx zzx2) {
        this(builder);
    }

    public static class Builder {
        private long zzagZ;
        private long zzaTo;
        private DataSet zzaVi;

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            zzbo.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{l});
            zzbo.zzb((l2 >= l ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{l2});
            this.zzagZ = timeUnit.toMillis(l);
            this.zzaTo = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setDataSet(DataSet dataSet) {
            zzbo.zzb((Object)((Object)dataSet), (Object)"Must set the data set");
            this.zzaVi = dataSet;
            return this;
        }

        public DataUpdateRequest build() {
            Builder builder = this;
            zzbo.zza((long)builder.zzagZ, (Object)"Must set a non-zero value for startTimeMillis/startTime");
            zzbo.zza((long)builder.zzaTo, (Object)"Must set a non-zero value for endTimeMillis/endTime");
            zzbo.zzb((Object)((Object)builder.zzaVi), (Object)"Must set the data set");
            for (DataPoint dataPoint : builder.zzaVi.getDataPoints()) {
                long l;
                long l2 = dataPoint.getStartTime(TimeUnit.MILLISECONDS);
                zzbo.zza((!(l2 > (l = dataPoint.getEndTime(TimeUnit.MILLISECONDS)) || l2 != 0L && l2 < builder.zzagZ || l2 != 0L && l2 > builder.zzaTo || l > builder.zzaTo || l < builder.zzagZ) ? 1 : 0) != 0, (String)"Data Point's startTimeMillis %d, endTimeMillis %d should lie between timeRange provided in the request. StartTimeMillis %d, EndTimeMillis: %d", (Object[])new Object[]{l2, l, builder.zzagZ, builder.zzaTo});
            }
            return new DataUpdateRequest(this, null);
        }
    }
}

