/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zze;
import com.google.android.gms.fitness.zza;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Bucket
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final int TYPE_TIME = 1;
    public static final int TYPE_SESSION = 2;
    public static final int TYPE_ACTIVITY_TYPE = 3;
    public static final int TYPE_ACTIVITY_SEGMENT = 4;
    private final int zzaku;
    private final long zzagZ;
    private final long zzaTo;
    private final Session zzaTe;
    private final int zzaTp;
    private final List<DataSet> zzaTq;
    private final int zzaTr;
    private boolean zzaTs = false;
    public static final Parcelable.Creator<Bucket> CREATOR = new zze();

    Bucket(int n, long l, long l2, Session session, int n2, List<DataSet> list, int n3, boolean bl) {
        this.zzaku = n;
        this.zzagZ = l;
        this.zzaTo = l2;
        this.zzaTe = session;
        this.zzaTp = n2;
        this.zzaTq = list;
        this.zzaTr = n3;
        this.zzaTs = bl;
    }

    public Bucket(RawBucket rawBucket, List<DataSource> list) {
        this(2, rawBucket.zzagZ, rawBucket.zzaTo, rawBucket.zzaTe, rawBucket.zzaUV, Bucket.zza(rawBucket.zzaTq, list), rawBucket.zzaTr, rawBucket.zzaTs);
    }

    private static List<DataSet> zza(Collection<RawDataSet> collection, List<DataSource> list) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(collection.size());
        for (RawDataSet rawDataSet : collection) {
            arrayList.add(new DataSet(rawDataSet, list));
        }
        return arrayList;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzagZ, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaTo, TimeUnit.MILLISECONDS);
    }

    public Session getSession() {
        return this.zzaTe;
    }

    public String getActivity() {
        return zza.getName(this.zzaTp);
    }

    public final int zztD() {
        return this.zzaTp;
    }

    public List<DataSet> getDataSets() {
        return this.zzaTq;
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzaTq) {
            if (!dataSet.getDataType().equals((Object)dataType)) continue;
            return dataSet;
        }
        return null;
    }

    public int getBucketType() {
        return this.zzaTr;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof Bucket)) break block3;
                Bucket bucket = (Bucket)((Object)object);
                Bucket bucket2 = this;
                if (!(bucket2.zzagZ == bucket.zzagZ && bucket2.zzaTo == bucket.zzaTo && bucket2.zzaTp == bucket.zzaTp && zzbe.equal(bucket2.zzaTq, bucket.zzaTq) && bucket2.zzaTr == bucket.zzaTr && bucket2.zzaTs == bucket.zzaTs)) break block3;
            }
            return true;
        }
        return false;
    }

    public final boolean zza(Bucket bucket) {
        return this.zzagZ == bucket.zzagZ && this.zzaTo == bucket.zzaTo && this.zzaTp == bucket.zzaTp && this.zzaTr == bucket.zzaTr;
    }

    public final boolean zztE() {
        if (this.zzaTs) {
            return true;
        }
        Iterator<DataSet> iterator = this.zzaTq.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().zztE()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzagZ, this.zzaTo, this.zzaTp, this.zzaTr});
    }

    public String toString() {
        return zzbe.zzt((Object)((Object)this)).zzg("startTime", (Object)this.zzagZ).zzg("endTime", (Object)this.zzaTo).zzg("activity", (Object)this.zzaTp).zzg("dataSets", this.zzaTq).zzg("bucketType", (Object)Bucket.zzaS(this.zzaTr)).zzg("serverHasMoreData", (Object)this.zzaTs).toString();
    }

    public static String zzaS(int n) {
        switch (n) {
            case 1: {
                return "time";
            }
            case 3: {
                return "type";
            }
            case 4: {
                return "segment";
            }
            case 2: {
                return "session";
            }
            case 0: {
                return "unknown";
            }
        }
        return "bug";
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Bucket bucket = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (long)bucket.zzagZ);
        zzd.zza((Parcel)parcel2, (int)2, (long)bucket.zzaTo);
        zzd.zza((Parcel)parcel2, (int)3, (Parcelable)bucket.getSession(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)4, (int)bucket.zzaTp);
        zzd.zzc((Parcel)parcel2, (int)5, bucket.getDataSets(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)6, (int)bucket.getBucketType());
        zzd.zza((Parcel)parcel2, (int)7, (boolean)bucket.zztE());
        zzd.zzc((Parcel)parcel2, (int)1000, (int)bucket.zzaku);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

