/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zze;
import com.google.android.gms.fitness.zza;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Bucket
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final int TYPE_TIME = 1;
    public static final int TYPE_SESSION = 2;
    public static final int TYPE_ACTIVITY_TYPE = 3;
    public static final int TYPE_ACTIVITY_SEGMENT = 4;
    private final int zzdxt;
    private final long zzdqy;
    private final long zzgrx;
    private final Session zzgrn;
    private final int zzgry;
    private final List<DataSet> zzgrz;
    private final int zzgsa;
    private boolean zzgsb = false;
    public static final Parcelable.Creator<Bucket> CREATOR = new zze();

    Bucket(int n, long l, long l2, Session session, int n2, List<DataSet> list, int n3, boolean bl) {
        this.zzdxt = n;
        this.zzdqy = l;
        this.zzgrx = l2;
        this.zzgrn = session;
        this.zzgry = n2;
        this.zzgrz = list;
        this.zzgsa = n3;
        this.zzgsb = bl;
    }

    public Bucket(RawBucket rawBucket, List<DataSource> list) {
        this(2, rawBucket.zzdqy, rawBucket.zzgrx, rawBucket.zzgrn, rawBucket.zzgve, Bucket.zza(rawBucket.zzgrz, list), rawBucket.zzgsa, rawBucket.zzgsb);
    }

    private static List<DataSet> zza(Collection<RawDataSet> collection, List<DataSource> list) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(collection.size());
        for (RawDataSet rawDataSet : collection) {
            arrayList.add(new DataSet(rawDataSet, list));
        }
        return arrayList;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzdqy, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzgrx, TimeUnit.MILLISECONDS);
    }

    public Session getSession() {
        return this.zzgrn;
    }

    public String getActivity() {
        return zza.getName(this.zzgry);
    }

    public final int zzaog() {
        return this.zzgry;
    }

    public List<DataSet> getDataSets() {
        return this.zzgrz;
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzgrz) {
            if (!dataSet.getDataType().equals((Object)dataType)) continue;
            return dataSet;
        }
        return null;
    }

    public int getBucketType() {
        return this.zzgsa;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof Bucket)) break block3;
                Bucket bucket = (Bucket)((Object)object);
                Bucket bucket2 = this;
                if (!(bucket2.zzdqy == bucket.zzdqy && bucket2.zzgrx == bucket.zzgrx && bucket2.zzgry == bucket.zzgry && zzbf.equal(bucket2.zzgrz, bucket.zzgrz) && bucket2.zzgsa == bucket.zzgsa && bucket2.zzgsb == bucket.zzgsb)) break block3;
            }
            return true;
        }
        return false;
    }

    public final boolean zza(Bucket bucket) {
        return this.zzdqy == bucket.zzdqy && this.zzgrx == bucket.zzgrx && this.zzgry == bucket.zzgry && this.zzgsa == bucket.zzgsa;
    }

    public final boolean zzaoh() {
        if (this.zzgsb) {
            return true;
        }
        Iterator<DataSet> iterator = this.zzgrz.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().zzaoh()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzdqy, this.zzgrx, this.zzgry, this.zzgsa});
    }

    public String toString() {
        return zzbf.zzt((Object)((Object)this)).zzg("startTime", (Object)this.zzdqy).zzg("endTime", (Object)this.zzgrx).zzg("activity", (Object)this.zzgry).zzg("dataSets", this.zzgrz).zzg("bucketType", (Object)Bucket.zzcv(this.zzgsa)).zzg("serverHasMoreData", (Object)this.zzgsb).toString();
    }

    public static String zzcv(int n) {
        switch (n) {
            case 1: {
                return "time";
            }
            case 3: {
                return "type";
            }
            case 4: {
                return "segment";
            }
            case 2: {
                return "session";
            }
            case 0: {
                return "unknown";
            }
        }
        return "bug";
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Bucket bucket = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (long)bucket.zzdqy);
        zzd.zza((Parcel)parcel2, (int)2, (long)bucket.zzgrx);
        zzd.zza((Parcel)parcel2, (int)3, (Parcelable)bucket.getSession(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)4, (int)bucket.zzgry);
        zzd.zzc((Parcel)parcel2, (int)5, bucket.getDataSets(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)6, (int)bucket.getBucketType());
        zzd.zza((Parcel)parcel2, (int)7, (boolean)bucket.zzaoh());
        zzd.zzc((Parcel)parcel2, (int)1000, (int)bucket.zzdxt);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }
}

